/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.client.gui;

import com.charles445.simpledifficulty.api.config.QuickConfig;
import com.charles445.simpledifficulty.api.temperature.ITemperatureDynamicModifier;
import com.charles445.simpledifficulty.api.temperature.ITemperatureModifier;
import com.charles445.simpledifficulty.api.temperature.TemperatureRegistry;
import com.charles445.simpledifficulty.api.temperature.TemperatureUtil;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.util.WorldUtil;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TemperatureInfoGui {
    private final Minecraft mc = Minecraft.func_71410_x();
    private int updateCounter = 0;
    public int xPadding = 2;
    public int yPadding = 2;
    public int transparency = -587202560;
    public int defaultColor = 0xFFFFFF | this.transparency;
    public int coldColor = 0x7777FF | this.transparency;
    public int hotColor = 0xFF7777 | this.transparency;
    public Map<String, Float> resultMap = new TreeMap<String, Float>();
    public int resultCumulative = 0;

    @SubscribeEvent
    public void onPostRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && QuickConfig.isTemperatureEnabled() && ModConfig.client.temperatureReadout && !this.mc.field_71474_y.field_74330_P && (this.mc.field_71439_g.func_184840_I() >= 2 || this.mc.func_71356_B() || this.mc.field_71439_g.func_184812_l_())) {
            ScaledResolution resolution = event.getResolution();
            this.displayTemperature(resolution.func_78326_a(), resolution.func_78328_b());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++this.updateCounter;
            if (this.updateCounter % 10 == 0 && ModConfig.client.temperatureReadout) {
                this.updateTemperature();
            }
        }
    }

    public void updateTemperature() {
        if (this.mc.field_71441_e == null || this.mc.field_71439_g == null) {
            return;
        }
        WorldClient world = this.mc.field_71441_e;
        EntityPlayerSP player = this.mc.field_71439_g;
        BlockPos pos = WorldUtil.getSidedBlockPos((World)world, (Entity)player);
        this.resultMap.clear();
        float cumulative = 0.0f;
        for (ITemperatureModifier iTemperatureModifier : TemperatureRegistry.modifiers.values()) {
            float result = iTemperatureModifier.getWorldInfluence((World)world, pos);
            this.resultMap.put(iTemperatureModifier.getName(), Float.valueOf(result += iTemperatureModifier.getPlayerInfluence((EntityPlayer)player)));
            cumulative += result;
        }
        for (ITemperatureDynamicModifier iTemperatureDynamicModifier : TemperatureRegistry.dynamicModifiers.values()) {
            float oldCumulative = cumulative;
            cumulative = iTemperatureDynamicModifier.applyDynamicWorldInfluence((World)world, pos, cumulative);
            cumulative = iTemperatureDynamicModifier.applyDynamicPlayerInfluence((EntityPlayer)player, cumulative);
            this.resultMap.put(iTemperatureDynamicModifier.getName(), Float.valueOf(cumulative - oldCumulative));
        }
        this.resultCumulative = (int)cumulative;
    }

    public void displayTemperature(int width, int height) {
        GlStateManager.func_179147_l();
        int yIncrement = this.mc.field_71466_p.field_78288_b;
        int xOffset = 0;
        int yOffset = 0;
        for (Map.Entry<String, Float> entry : this.resultMap.entrySet()) {
            xOffset = 0;
            String name = entry.getKey();
            Float value = entry.getValue();
            int valueColor = this.defaultColor;
            if (value.floatValue() > 0.0f) {
                valueColor = this.hotColor;
            } else if (value.floatValue() < 0.0f) {
                valueColor = this.coldColor;
            }
            xOffset = this.mc.field_71466_p.func_175065_a(name + ": ", (float)(this.xPadding + xOffset), (float)(this.yPadding + yOffset), this.defaultColor, true);
            xOffset = this.mc.field_71466_p.func_175065_a("" + value, (float)(this.xPadding + xOffset), (float)(this.yPadding + yOffset), valueColor, true);
            yOffset += yIncrement;
        }
        int valueColor = this.defaultColor;
        switch (TemperatureUtil.getTemperatureEnum(this.resultCumulative)) {
            case BURNING: 
            case HOT: {
                valueColor = this.hotColor;
                break;
            }
            case COLD: 
            case FREEZING: {
                valueColor = this.coldColor;
                break;
            }
        }
        xOffset = 0;
        xOffset = this.mc.field_71466_p.func_175065_a("---------", (float)(this.xPadding + xOffset), (float)(this.yPadding + yOffset), this.defaultColor, true);
        xOffset = 0;
        xOffset = this.mc.field_71466_p.func_175065_a("Result: ", (float)(this.xPadding + xOffset), (float)(this.yPadding + (yOffset += yIncrement)), this.defaultColor, true);
        xOffset = this.mc.field_71466_p.func_175065_a("" + this.resultCumulative, (float)(this.xPadding + xOffset), (float)(this.yPadding + yOffset), valueColor, true);
        yOffset += yIncrement;
        GlStateManager.func_179084_k();
    }
}

