/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="silentlib")
public final class EntityHelper {
    private static volatile Queue<Entity> entitiesToSpawn = Queues.newArrayDeque();

    private EntityHelper() {
        throw new IllegalAccessError("Utility class");
    }

    @Deprecated
    public static void moveSelf(Entity entity, double x, double y, double z) {
        entity.func_70091_d(MoverType.SELF, x, y, z);
    }

    @Deprecated
    public static List<String> getEntityNameList() {
        ArrayList list = Lists.newArrayList();
        EntityList.func_180124_b().forEach(res -> list.add(EntityList.func_191302_a((ResourceLocation)res)));
        return list;
    }

    public static void safeSpawn(Entity entity) {
        entitiesToSpawn.add(entity);
    }

    private static void handleSpawns() {
        Entity entity;
        while ((entity = entitiesToSpawn.poll()) != null) {
            entity.field_70170_p.func_72838_d(entity);
        }
    }

    public static void heal(EntityLivingBase entityLiving, float healAmount, boolean cancelable) {
        if (cancelable) {
            entityLiving.func_70691_i(healAmount);
        } else {
            entityLiving.func_70606_j(entityLiving.func_110143_aJ() + healAmount);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityHelper.handleSpawns();
        }
    }
}

