/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.phasepointfixes;

import com.dhanantry.scapeandrunparasites.item.ItemEPClock;
import com.dhanantry.scapeandrunparasites.network.SRPCommandEvolution;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import srpmixins.handlers.SRPMixinsConfigHandler;
import srpmixins.util.SRPSaveDataInterface;

@Mixin(value={ItemEPClock.class})
public abstract class ModifiedBloodyClock {
    @Unique
    private SRPSaveData saveData;

    @Inject(method={"func_77659_a"}, at={@At(value="HEAD")}, remap=false)
    public void saveWorldDataMixin(World worldIn, EntityPlayer playerIn, EnumHand handIn, CallbackInfoReturnable<ActionResult<ItemStack>> cir) {
        if (!worldIn.field_72995_K) {
            this.saveData = SRPSaveData.get((World)worldIn);
            if (SRPMixinsConfigHandler.phasepoints.playerPhases) {
                this.saveData = ((SRPSaveDataInterface)this.saveData).getByPlayer(worldIn, playerIn.func_110124_au());
            }
        }
    }

    @Redirect(method={"func_77659_a"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/EntityPlayer;func_146105_b(Lnet/minecraft/util/text/ITextComponent;Z)V"), remap=false)
    public void sendPhaseMessageToChatMixin(EntityPlayer player, ITextComponent iTextComponent, boolean b) {
        if (SRPMixinsConfigHandler.phasepoints.modifyBloodyClock) {
            int dimension = player.func_130014_f_().field_73011_w.getDimension();
            byte evoPhase = this.saveData.getEvolutionPhase(dimension);
            int pointsNext = SRPCommandEvolution.getNeededPoints((byte)((byte)Math.min(evoPhase + 1, 8)));
            int pointsThis = SRPCommandEvolution.getNeededPoints((byte)evoPhase);
            int perc = (int)Math.round(100.0 * ((double)this.saveData.getTotalKills(dimension) - (double)pointsThis) / ((double)pointsNext - (double)pointsThis));
            if (pointsNext == pointsThis) {
                perc = 0;
            }
            int cooldown = this.saveData.getCooldown(player.func_130014_f_(), dimension);
            if (SRPMixinsConfigHandler.phasepoints.bloodyClockShowsCooldown && cooldown > 0) {
                int hours = cooldown / 3600;
                int minutes = (cooldown -= 3600 * hours) / 60;
                int seconds = cooldown -= 60 * minutes;
                TextComponentTranslation cooldownMsg = hours > 0 ? new TextComponentTranslation("socketed.bloodyclock.hours", new Object[]{hours, minutes, seconds}) : (minutes > 0 ? new TextComponentTranslation("socketed.bloodyclock.minutes", new Object[]{minutes, seconds}) : new TextComponentTranslation("socketed.bloodyclock.seconds", new Object[]{seconds}));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("srpmixins.bloodyclock.phaseandcooldown", new Object[]{Integer.toString(evoPhase), perc, cooldownMsg}), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("srpmixins.bloodyclock.currentphase", new Object[]{Integer.toString(evoPhase), perc}), true);
            }
        } else {
            player.func_146105_b(iTextComponent, b);
        }
    }
}

