/*
 * Decompiled with CFR 0.152.
 */
package srpmixins.mixin.lostcitytweaks;

import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import mcjty.lostcities.ForgeEventHandlers;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.varia.CustomTeleporter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import srpmixins.handlers.SRPMixinsConfigHandler;
import srpmixins.util.SRPSaveDataInterface;

@Mixin(value={ForgeEventHandlers.class})
public abstract class LCPortalPhaseLock {
    @Redirect(method={"onPlayerSleepInBedEvent"}, at=@At(value="INVOKE", target="Lmcjty/lostcities/varia/CustomTeleporter;teleportToDimension(Lnet/minecraft/entity/player/EntityPlayer;ILnet/minecraft/util/math/BlockPos;)V"), remap=false)
    void lockPortalBehindPhase(EntityPlayer player, int dimension, BlockPos pos) {
        if (!SRPConfigSystems.useEvolution) {
            return;
        }
        if (SRPMixinsConfigHandler.modcompat.portalLClockedPhase > -1 && dimension == LostCityConfiguration.DIMENSION_ID) {
            World world = player.func_130014_f_();
            SRPSaveData data = SRPSaveData.get((World)world);
            int dimensionPlayer = world.field_73011_w.getDimension();
            byte evoPhase = SRPMixinsConfigHandler.phasepoints.playerPhases ? ((SRPSaveDataInterface)data).getByPlayer(world, player.func_110124_au()).getEvolutionPhase(dimensionPlayer) : data.getEvolutionPhase(dimensionPlayer);
            if (evoPhase >= SRPMixinsConfigHandler.modcompat.portalLClockedPhase) {
                CustomTeleporter.teleportToDimension((EntityPlayer)player, (int)LostCityConfiguration.DIMENSION_ID, (BlockPos)pos);
            } else {
                player.func_146105_b(new TextComponentTranslation("srpmixins.msg.fearincapacitates", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                Potion fearEffect = Potion.func_180142_b((String)"lycanitesmobs:fear");
                if (fearEffect != null) {
                    player.func_70690_d(new PotionEffect(fearEffect, 100, 0));
                }
            }
        }
    }

    @Inject(method={"onPlayerSleepInBedEvent"}, at={@At(value="INVOKE", target="Lmcjty/lostcities/varia/CustomTeleporter;teleportToDimension(Lnet/minecraft/entity/player/EntityPlayer;ILnet/minecraft/util/math/BlockPos;)V")}, remap=false)
    void stopSleepingMixin(PlayerSleepInBedEvent event, CallbackInfo ci) {
        if (!SRPConfigSystems.useEvolution) {
            return;
        }
        if (event.getResult() == Event.Result.DENY) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
        }
    }
}

