/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.shapes;

import com.google.common.collect.Sets;
import greymerk.roguelike.worldgen.Bounded;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.shapes.IShape;
import greymerk.roguelike.worldgen.shapes.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RectSolid
implements IShape,
Bounded {
    private final Coord start;
    private final Coord end;

    private RectSolid(Coord start, Coord end) {
        this.start = start.copy();
        this.end = end.copy();
    }

    public static RectSolid newRect(Coord start, Coord end) {
        return new RectSolid(start, end);
    }

    public RectSolid withHeight(int height) {
        Coord lower = this.start.getY() < this.end.getY() ? this.start : this.end;
        this.start.setY(lower.getY());
        this.end.setY(lower.getY() + Math.max(0, height - 1));
        return this;
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> coords = new ArrayList<Coord>();
        for (Coord c : this) {
            coords.add(c);
        }
        return coords;
    }

    @Override
    public Set<Coord> getAnchors() {
        return Sets.newHashSet((Object[])new Coord[]{this.start, this.end});
    }

    @Override
    public Iterator<Coord> iterator() {
        return new RectSolidIterator(this.start, this.end);
    }

    @Override
    public IShape getShape(Shape type) {
        return this;
    }

    @Override
    public Coord getStart() {
        return this.start;
    }

    @Override
    public Coord getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RectSolid)) {
            return false;
        }
        RectSolid other = (RectSolid)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Coord this$start = this.getStart();
        Coord other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Coord this$end = this.getEnd();
        Coord other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RectSolid;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Coord $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Coord $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }

    private static class RectSolidIterator
    implements Iterator<Coord> {
        Coord cursor;
        Coord start;
        Coord end;

        public RectSolidIterator(Coord start, Coord end) {
            this.start = start.copy();
            this.end = end.copy();
            Coord.correct(this.start, this.end);
            this.cursor = this.start.copy();
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() <= this.end.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.cursor.copy();
            if (this.cursor.getZ() == this.end.getZ() && this.cursor.getX() == this.end.getX()) {
                this.cursor = new Coord(this.start.getX(), this.cursor.getY(), this.start.getZ());
                this.cursor.up();
                return toReturn;
            }
            if (this.cursor.getX() == this.end.getX()) {
                this.cursor = new Coord(this.start.getX(), this.cursor.getY(), this.cursor.getZ());
                this.cursor.south();
                return toReturn;
            }
            this.cursor.east();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

