/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.github.fnar.minecraft.Effect;
import com.github.fnar.minecraft.EffectType;
import com.github.fnar.minecraft.item.Potion;
import com.github.fnar.minecraft.item.RldItemStack;
import com.github.fnar.util.Color;
import greymerk.roguelike.treasure.loot.ItemHideFlags;
import java.util.Random;

public enum PotionMixture {
    ABSINTHE,
    AURA,
    COFFEE,
    LAUDANUM,
    MOONSHINE,
    NECTAR,
    RAGE,
    STAMINA,
    STOUT,
    TEQUILA,
    VILE;

    public static final PotionMixture[] POTIONS;
    public static final PotionMixture[] BOOZE;

    public static RldItemStack chooseRandomBooze(Random random) {
        return PotionMixture.getPotion(random, PotionMixture.chooseRandomAmong(random, BOOZE));
    }

    public static RldItemStack chooseRandomPotion(Random random) {
        return PotionMixture.getPotion(random, PotionMixture.chooseRandomAmong(random, POTIONS));
    }

    public static PotionMixture chooseRandom(Random random) {
        return PotionMixture.chooseRandomAmong(random, PotionMixture.values());
    }

    public static PotionMixture chooseRandomAmong(Random random, PotionMixture[] potions) {
        return potions[random.nextInt(potions.length)];
    }

    public static RldItemStack getPotion(Random random, PotionMixture type) {
        return PotionMixture.getPotionAsRldItemStack(random, type);
    }

    public static RldItemStack getPotionAsRldItemStack(Random random, PotionMixture type) {
        switch (type) {
            case ABSINTHE: {
                return PotionMixture.getAbsinthe();
            }
            case AURA: {
                return PotionMixture.getAura();
            }
            case COFFEE: {
                return PotionMixture.getCoffee();
            }
            case LAUDANUM: {
                return PotionMixture.getLaudanum();
            }
            case MOONSHINE: {
                return PotionMixture.getMoonshine(random);
            }
            case NECTAR: {
                return PotionMixture.getNectar();
            }
            case RAGE: {
                return PotionMixture.getRage();
            }
            case STAMINA: {
                return PotionMixture.getStamina();
            }
            case STOUT: {
                return PotionMixture.getStout();
            }
            case TEQUILA: {
                return PotionMixture.getTequila(random);
            }
        }
        return PotionMixture.getVile(random);
    }

    public static RldItemStack getTequila(Random random) {
        return Potion.newPotion().withEffect(Effect.newEffect(EffectType.STRENGTH, 2, 30 + random.nextInt(60))).withEffect(Effect.newEffect(EffectType.FATIGUE, 0, 30 + random.nextInt(60))).withColor(Color.POPCORN).asStack().withDisplayName("mixture.roguelike.tequila.name").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static RldItemStack getLaudanum() {
        return Potion.newPotion().withEffect(Effect.newEffect(EffectType.REGEN, 2, 8)).withEffect(Effect.newEffect(EffectType.WEAKNESS, 1, 5)).withEffect(Effect.newEffect(EffectType.SLOWNESS, 1, 5)).withEffect(Effect.newEffect(EffectType.FATIGUE, 1, 5)).withEffect(Effect.newEffect(EffectType.NAUSEA, 0, 5)).withColor(Color.SPLIT_PEA_SOUP).asStack().withDisplayName("mixture.roguelike.laudanum.name").withDisplayLore("A medicinal tincture.").withDisplayLocLore("mixture.roguelike.laudanum.lore").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static RldItemStack getMoonshine(Random random) {
        return Potion.newPotion().withEffect(Effect.newEffect(EffectType.DAMAGE, 0, 1)).withEffect(Effect.newEffect(EffectType.BLINDNESS, 0, 30 + random.nextInt(60))).withEffect(Effect.newEffect(EffectType.RESISTANCE, 1, 30 + random.nextInt(30))).withColor(Color.ICE_FISHING).asStack().withDisplayName("mixture.roguelike.moonshine.name").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static RldItemStack getAbsinthe() {
        return Potion.newPotion().withEffect(Effect.newEffect(EffectType.POISON, 0, 3)).withEffect(Effect.newEffect(EffectType.NIGHT_VISION, 0, 120)).withEffect(Effect.newEffect(EffectType.JUMP, 2, 120)).withColor(Color.ADVERTISING_GREEN).asStack().withDisplayName("mixture.roguelike.absinthe.name").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static RldItemStack getVile(Random random) {
        EffectType randomEffect0 = EffectType.chooseRandom(random);
        EffectType randomEffect1 = EffectType.chooseRandom(random);
        return Potion.newPotion().withForm(Potion.Form.chooseRandom(random)).withEffect(Potion.Effect.chooseRandom(random)).withAmplification(random.nextBoolean()).withExtension(random.nextBoolean()).withEffect(Effect.newEffect().withType(randomEffect0).withAmplification(Potion.Amplification.chooseRandom(random)).withDuration(PotionMixture.getSuggestedDuration(random, randomEffect0))).withEffect(Effect.newEffect().withType(randomEffect1).withAmplification(Potion.Amplification.chooseRandom(random)).withDuration(PotionMixture.getSuggestedDuration(random, randomEffect1))).withColor(Color.random(random)).asStack().withDisplayName("mixture.roguelike.vile.name").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static RldItemStack getRage() {
        return Potion.newPotion().withEffect(Effect.newEffect(EffectType.STRENGTH, 2, 20)).withEffect(Effect.newEffect(EffectType.BLINDNESS, 0, 10)).withEffect(Effect.newEffect(EffectType.WITHER, 0, 3)).withColor(Color.BLUE).asStack().withDisplayName("mixture.roguelike.rage.name").withDisplayLore("An unstable mixture.").withDisplayLocLore("mixture.roguelike.rage.lore").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static RldItemStack getStamina() {
        return Potion.newPotion().withEffect(Effect.newEffect(EffectType.SATURATION, 9, 1)).withEffect(Effect.newEffect(EffectType.SPEED, 1, 120)).withEffect(Effect.newEffect(EffectType.HASTE, 1, 120)).withEffect(Effect.newEffect(EffectType.JUMP, 2, 120)).withColor(Color.WHITE).asStack().withDisplayName("mixture.roguelike.stamina.name").withDisplayLore("Essence of life.").withDisplayLocLore("mixture.roguelike.stamina.lore").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static RldItemStack getStout() {
        return Potion.newPotion().withEffect(Effect.newEffect(EffectType.REGEN, 0, 5)).withEffect(Effect.newEffect(EffectType.SATURATION, 1, 1)).withEffect(Effect.newEffect(EffectType.HEALTH_BOOST, 1, 120)).withEffect(Effect.newEffect(EffectType.RESISTANCE, 0, 120)).withColor(Color.ENGLISH_BREAKFAST).asStack().withDisplayName("mixture.roguelike.stout.name").withDisplayLore("\"It's Good for You\"").withDisplayLocLore("mixture.roguelike.stout.lore").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static RldItemStack getNectar() {
        return Potion.newPotion().withEffect(Effect.newEffect(EffectType.ABSORPTION, 9, 20)).withEffect(Effect.newEffect(EffectType.RESISTANCE, 2, 20)).withEffect(Effect.newEffect(EffectType.HEALTH, 1, 1)).withColor(Color.SUNNY_MOOD).asStack().withDisplayName("mixture.roguelike.nectar.name").withDisplayLore("A Floral extract.").withDisplayLocLore("mixture.roguelike.nectar.lore").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static RldItemStack getCoffee() {
        return Potion.newPotion().withEffect(Effect.newEffect(EffectType.HASTE, 1, 600)).withEffect(Effect.newEffect(EffectType.SPEED, 0, 600)).withColor(Color.COFFEE).asStack().withDisplayName("mixture.roguelike.coffee.name").withDisplayLore("A darkroast bean brew.").withDisplayLocLore("mixture.roguelike.coffee.lore").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static RldItemStack getAura() {
        return Potion.newPotion().withEffect(Effect.newEffect(EffectType.GLOWING, 0, 600)).withColor(Color.DELAYED_YELLOW).asStack().withDisplayName("mixture.roguelike.aura.name").withDisplayLore("A glowstone extract.").withDisplayLocLore("mixture.roguelike.aura.lore").withHideFlag(ItemHideFlags.EFFECTS);
    }

    public static int getSuggestedDuration(Random random, EffectType type) {
        switch (type) {
            case SATURATION: 
            case HEALTH: 
            case DAMAGE: {
                return 1;
            }
            case REGEN: {
                return 10 + random.nextInt(20);
            }
            case HUNGER: {
                return 5 + random.nextInt(10);
            }
            case WITHER: 
            case POISON: {
                return 5 + random.nextInt(5);
            }
        }
        return 60 + random.nextInt(120);
    }

    static {
        POTIONS = new PotionMixture[]{LAUDANUM, RAGE, STAMINA, NECTAR, COFFEE, AURA};
        BOOZE = new PotionMixture[]{TEQUILA, LAUDANUM, MOONSHINE, ABSINTHE, STOUT};
    }
}

