/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.theme;

import com.github.fnar.minecraft.block.BlockType;
import com.github.fnar.minecraft.block.normal.StairsBlock;
import com.github.fnar.minecraft.block.redstone.DoorBlock;
import com.github.fnar.minecraft.material.Wood;
import greymerk.roguelike.worldgen.BlockBrush;
import java.util.Optional;

public class BlockSet {
    private BlockBrush floor = Wood.OAK.getPlanks();
    private BlockBrush walls = BlockType.STONE_BRICKS.getBrush();
    private StairsBlock stair = StairsBlock.stoneBrick();
    private BlockBrush pillar = Wood.OAK.getLog();
    private DoorBlock door = DoorBlock.oak();
    private BlockBrush lightBlock = BlockType.GLOWSTONE.getBrush();
    private BlockBrush liquid = BlockType.WATER_FLOWING.getBrush();

    public BlockSet() {
    }

    public BlockSet(BlockBrush floor, BlockBrush walls, StairsBlock stair, BlockBrush pillar, DoorBlock door, BlockBrush lightBlock, BlockBrush liquid) {
        this.floor = floor;
        this.walls = walls;
        this.stair = stair;
        this.pillar = pillar;
        this.door = door;
        this.lightBlock = lightBlock;
        this.liquid = liquid;
    }

    static BlockSet inherit(BlockSet parentBlockSet, BlockSet childBlockSet) {
        if (parentBlockSet == null && childBlockSet == null) {
            return new BlockSet();
        }
        if (parentBlockSet == null) {
            return childBlockSet;
        }
        if (childBlockSet == null) {
            return parentBlockSet;
        }
        return new BlockSet(Optional.ofNullable(childBlockSet.getFloor()).orElse(parentBlockSet.getFloor()), Optional.ofNullable(childBlockSet.getWall()).orElse(parentBlockSet.getWall()), Optional.ofNullable(childBlockSet.getStair()).orElse(parentBlockSet.getStair()), Optional.ofNullable(childBlockSet.getPillar()).orElse(parentBlockSet.getPillar()), Optional.ofNullable(childBlockSet.getDoor()).orElse(parentBlockSet.getDoor()), Optional.ofNullable(childBlockSet.getLightBlock()).orElse(parentBlockSet.getLightBlock()), Optional.ofNullable(childBlockSet.getLiquid()).orElse(parentBlockSet.getLiquid()));
    }

    public BlockBrush getWall() {
        return this.walls.copy();
    }

    public StairsBlock getStair() {
        return this.stair.copy();
    }

    public BlockBrush getPillar() {
        return Optional.ofNullable(this.pillar).orElse(this.getWall()).copy();
    }

    public BlockBrush getFloor() {
        return Optional.ofNullable(this.floor).orElse(this.getWall()).copy();
    }

    public DoorBlock getDoor() {
        return this.door.copy();
    }

    public BlockBrush getLightBlock() {
        return this.lightBlock.copy();
    }

    public BlockBrush getLiquid() {
        return this.liquid.copy();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockSet)) {
            return false;
        }
        BlockSet other = (BlockSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockBrush this$floor = this.getFloor();
        BlockBrush other$floor = other.getFloor();
        if (this$floor == null ? other$floor != null : !this$floor.equals(other$floor)) {
            return false;
        }
        BlockBrush this$walls = this.walls;
        BlockBrush other$walls = other.walls;
        if (this$walls == null ? other$walls != null : !this$walls.equals(other$walls)) {
            return false;
        }
        StairsBlock this$stair = this.getStair();
        StairsBlock other$stair = other.getStair();
        if (this$stair == null ? other$stair != null : !((Object)this$stair).equals(other$stair)) {
            return false;
        }
        BlockBrush this$pillar = this.getPillar();
        BlockBrush other$pillar = other.getPillar();
        if (this$pillar == null ? other$pillar != null : !this$pillar.equals(other$pillar)) {
            return false;
        }
        DoorBlock this$door = this.getDoor();
        DoorBlock other$door = other.getDoor();
        if (this$door == null ? other$door != null : !((Object)this$door).equals(other$door)) {
            return false;
        }
        BlockBrush this$lightBlock = this.getLightBlock();
        BlockBrush other$lightBlock = other.getLightBlock();
        if (this$lightBlock == null ? other$lightBlock != null : !this$lightBlock.equals(other$lightBlock)) {
            return false;
        }
        BlockBrush this$liquid = this.getLiquid();
        BlockBrush other$liquid = other.getLiquid();
        return !(this$liquid == null ? other$liquid != null : !this$liquid.equals(other$liquid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockBrush $floor = this.getFloor();
        result = result * 59 + ($floor == null ? 43 : $floor.hashCode());
        BlockBrush $walls = this.walls;
        result = result * 59 + ($walls == null ? 43 : $walls.hashCode());
        StairsBlock $stair = this.getStair();
        result = result * 59 + ($stair == null ? 43 : ((Object)$stair).hashCode());
        BlockBrush $pillar = this.getPillar();
        result = result * 59 + ($pillar == null ? 43 : $pillar.hashCode());
        DoorBlock $door = this.getDoor();
        result = result * 59 + ($door == null ? 43 : ((Object)$door).hashCode());
        BlockBrush $lightBlock = this.getLightBlock();
        result = result * 59 + ($lightBlock == null ? 43 : $lightBlock.hashCode());
        BlockBrush $liquid = this.getLiquid();
        result = result * 59 + ($liquid == null ? 43 : $liquid.hashCode());
        return result;
    }

    public String toString() {
        return "BlockSet(floor=" + this.getFloor() + ", walls=" + this.walls + ", stair=" + this.getStair() + ", pillar=" + this.getPillar() + ", door=" + this.getDoor() + ", lightBlock=" + this.getLightBlock() + ", liquid=" + this.getLiquid() + ")";
    }
}

