/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.config;

import greymerk.roguelike.config.Configuration;
import greymerk.roguelike.config.ConfigurationMap;
import greymerk.roguelike.config.INIParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigFile {
    private static final Logger logger = LogManager.getLogger((String)"roguelike");

    public static void read(ConfigurationMap configFile, String filename) {
        try {
            Configuration config;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0])));
            while ((config = INIParser.readLine(reader)) != null) {
                configFile.put(config.key, config.value);
            }
        }
        catch (Exception exception) {
            logger.error("Error while reading config file. : ", (Throwable)exception);
        }
    }

    public static void write(ConfigurationMap configFile, String filename) throws Exception {
        FileOutputStream stream = new FileOutputStream(filename, true);
        stream.getChannel().truncate(0L);
        BufferedWriter buffered = new BufferedWriter(new OutputStreamWriter(stream));
        for (Configuration configuration : configFile.asList()) {
            INIParser.write(configuration, buffered);
        }
        buffered.close();
    }
}

