/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.citadel;

import com.github.fnar.minecraft.block.SingleBlockBrush;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.dungeon.towers.TowerType;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.util.graph.Edge;
import greymerk.roguelike.util.graph.Graph;
import greymerk.roguelike.util.mst.MSTPoint;
import greymerk.roguelike.util.mst.MinimumSpanningTree;
import greymerk.roguelike.worldgen.BlockBrush;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.List;

public class CityGrounds {
    private final WorldEditor editor;
    private final MinimumSpanningTree mst;
    private final Theme theme;

    public CityGrounds(WorldEditor editor, MinimumSpanningTree mst, Theme theme) {
        this.editor = editor;
        this.mst = mst;
        this.theme = theme;
    }

    public void generate(Coord coord) {
        this.clearArea(coord);
        this.wall1(coord);
        this.wall2(coord);
        this.wall3(coord);
        for (Edge<MSTPoint> edge : this.mst.getEdges()) {
            Coord start = edge.getStart().getPosition().up(20);
            Coord end = edge.getEnd().getPosition();
            RectSolid.newRect(start, end).fill(this.editor, this.getWalls());
        }
        this.generateTowers(coord);
    }

    private BlockBrush getWalls() {
        return this.theme.getPrimary().getWall();
    }

    private void clearArea(Coord coord) {
        Coord start = coord.copy().translate(new Coord(-51, 10, -51));
        Coord end = coord.copy().translate(new Coord(51, 40, 51));
        RectSolid.newRect(start, end).fill(this.editor, SingleBlockBrush.AIR);
    }

    private void wall1(Coord coord) {
        Coord start = coord.copy().translate(new Coord(-51, 10, -51));
        Coord end = coord.copy().translate(new Coord(51, 20, 51));
        RectSolid.newRect(start, end).fill(this.editor, this.getWalls());
    }

    private void wall2(Coord coord) {
        Coord start = coord.copy().translate(new Coord(-34, 20, -34));
        Coord end = coord.copy().translate(new Coord(34, 30, 34));
        RectSolid.newRect(start, end).fill(this.editor, this.getWalls());
    }

    private void wall3(Coord coord) {
        Coord start = coord.copy().translate(new Coord(-17, 30, -17));
        Coord end = coord.copy().translate(new Coord(17, 40, 17));
        RectSolid.newRect(start, end).fill(this.editor, this.getWalls());
    }

    private void generateTowers(Coord coord) {
        Graph<Coord> layout = this.mst.getGraph();
        List<Coord> towers = layout.getPoints();
        for (Coord towerCoord : towers) {
            towerCoord.translate(coord);
            TowerType towerType = TowerType.random(this.editor.getRandom());
            Theme themeBase = Theme.random(this.editor.getRandom());
            Tower tower = towerType.instantiate(this.editor, themeBase);
            tower.generate(towerCoord.copy().setY(50));
        }
    }
}

