/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike;

import com.github.fnar.minecraft.EffectType;
import com.github.fnar.util.Pair;
import com.github.fnar.util.ReportThisIssueException;
import com.google.common.primitives.Ints;
import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.monster.EntityProfiler1_12;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityJoinWorld1_12 {
    @SubscribeEvent
    public void OnEntityJoinWorld(EntityJoinWorldEvent event) {
        try {
            EntityJoinWorld1_12.equipMobIfSpawnedByRoguelikeSpawner(event);
        }
        catch (Exception exception) {
            new ReportThisIssueException(exception).printStackTrace();
        }
    }

    private static void equipMobIfSpawnedByRoguelikeSpawner(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityMob) && !(entity instanceof EntitySlime)) {
            return;
        }
        if (entity.field_70128_L) {
            event.setCanceled(true);
            return;
        }
        EntityLiving entityLiving = (EntityLiving)entity;
        if (!EntityJoinWorld1_12.isMobFromRoguelikeSpawner(entityLiving)) {
            return;
        }
        EntityJoinWorld1_12.handleDespawning(entityLiving);
        if (RogueConfig.MOBS_PROFILES_ENABLED.getBoolean()) {
            EntityJoinWorld1_12.applyMobProfile(world, entityLiving);
        }
    }

    private static boolean isMobFromRoguelikeSpawner(EntityLiving entity) {
        return entity.func_70651_bq().stream().anyMatch(EntityJoinWorld1_12::isRoguelikeTag);
    }

    private static void applyMobProfile(World world, EntityLiving entity) {
        int difficulty;
        int level = Ints.constrainToRange((int)EntityJoinWorld1_12.getRoguelikeLevel(entity), (int)0, (int)4);
        EntityLiving newEntity = EntityProfiler1_12.applyProfile(entity, level, world.field_73012_v, difficulty = world.func_175659_aa().ordinal());
        if (newEntity == null) {
            return;
        }
        newEntity.func_82149_j((Entity)entity);
        EntityJoinWorld1_12.copyTags(entity, newEntity);
        Arrays.stream(EntityEquipmentSlot.values()).forEach(value -> newEntity.func_184642_a(value, (float)RogueConfig.MOBS_ITEMS_DROP_CHANCE.getDouble()));
        entity.field_70170_p.func_72900_e((Entity)entity);
        newEntity.field_70170_p.func_72838_d((Entity)newEntity);
    }

    private static int getRoguelikeLevel(EntityLiving entity) {
        return entity.func_70651_bq().stream().filter(EntityJoinWorld1_12::isRoguelikeTag).findFirst().map(PotionEffect::func_76458_c).orElse(0);
    }

    private static boolean isRoguelikeTag(PotionEffect buff) {
        return Potion.func_188409_a((Potion)buff.func_188419_a()) == EffectType.FATIGUE.getEffectID();
    }

    private static void copyTags(EntityLiving from, EntityLiving to) {
        EntityJoinWorld1_12.handleDespawning(to);
        from.func_184216_O().forEach(arg_0 -> ((EntityLiving)to).func_184211_a(arg_0));
        EntityJoinWorld1_12.copyEntityData(from, to);
    }

    private static void handleDespawning(EntityLiving entityLiving) {
        if (!RogueConfig.MOBS_DESPAWN_ENABLED.getBoolean()) {
            entityLiving.func_110163_bv();
        }
    }

    private static void copyEntityData(EntityLiving from, EntityLiving to) {
        from.getEntityData().func_150296_c().stream().map(tag -> new Pair<String, NBTBase>((String)tag, from.getEntityData().func_74781_a(tag))).forEach(tagPair -> to.getEntityData().func_74782_a((String)tagPair.getKey(), (NBTBase)tagPair.getValue()));
    }
}

