/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimedTask
implements Runnable {
    private static final Logger logger = LogManager.getLogger((String)"roguelike");
    private final String name;
    private final Runnable runnable;

    public TimedTask(String name, Runnable runnable) {
        this.name = name;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        try {
            this.runnable.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
        long end = System.currentTimeMillis();
        long runTime = end - start;
        logger.info(String.format("Task %s completed in %d milliseconds.", this.name, runTime));
    }
}

