/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.command.commands;

import com.github.fnar.roguelike.command.CommandContext;
import com.github.fnar.roguelike.command.commands.BaseRoguelikeCommand;
import greymerk.roguelike.dungeon.settings.SettingsResolver;
import java.util.Optional;

public class ListSettingsCommand
extends BaseRoguelikeCommand {
    private final String namespace;

    public ListSettingsCommand(CommandContext commandContext, String namespace) {
        super(commandContext);
        this.namespace = Optional.ofNullable(namespace).orElse("");
    }

    public static void sendUsage(CommandContext commandContext) {
        commandContext.sendInfo("notif.roguelike.usage_", "roguelike settings [reload | list]");
    }

    @Override
    public boolean onRun() {
        if (this.namespace.isEmpty()) {
            this.context.sendInfo(SettingsResolver.getInstance(this.context.getModLoader()).toString());
        } else {
            this.context.sendInfo(SettingsResolver.getInstance(this.context.getModLoader()).toString(this.namespace));
        }
        return true;
    }

    @Override
    public void onSuccess() {
        this.context.sendSuccess("settingslisted");
    }
}

