/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.roguelike.command.commands;

import com.github.fnar.roguelike.command.CommandContext;
import com.github.fnar.roguelike.command.commands.BaseRoguelikeCommand;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.WorldEditor;
import java.util.List;
import java.util.Optional;

public class BiomeCommand
extends BaseRoguelikeCommand {
    private final Coord coord;

    public BiomeCommand(CommandContext commandContext, Coord coord) {
        super(commandContext);
        this.coord = Optional.ofNullable(coord).orElse(commandContext.getSenderCoord());
    }

    @Override
    public boolean onRun() {
        this.context.sendSpecial("notif.roguelike.biomeinfo", this.coord.toString());
        WorldEditor editor = this.context.createEditor();
        this.context.sendSpecial(editor.getBiomeName(this.coord));
        List<String> typeNames = editor.getBiomeTagNames(this.coord);
        this.context.sendSpecial(String.join((CharSequence)"", typeNames));
        return true;
    }

    @Override
    public void onSuccess() {
        this.context.sendSuccess("biomeslisted");
    }
}

