/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item.mapper;

import com.github.fnar.minecraft.block.BlockMapper1_12;
import com.github.fnar.minecraft.block.CouldNotMapBlockException;
import com.github.fnar.minecraft.block.SingleBlockBrush;
import com.github.fnar.minecraft.item.CouldNotMapItemException;
import com.github.fnar.minecraft.item.Seed;
import com.github.fnar.minecraft.item.mapper.BaseItemMapper1_12;
import com.github.fnar.minecraft.material.Crop;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SeedMapper1_12
extends BaseItemMapper1_12<Seed> {
    @Override
    public Class<Seed> getClazz() {
        return Seed.class;
    }

    @Override
    public ItemStack map(Seed seed) throws CouldNotMapItemException {
        return this.addEnchantmentNbtTags(seed, this.mapToItem(seed));
    }

    private Item mapToItem(Seed item) throws CouldNotMapItemException {
        switch (item.getCrop()) {
            case BEETROOTS: {
                return Items.field_185164_cV;
            }
            case CARROTS: {
                return Items.field_151172_bF;
            }
            case COCOA: {
                return this.asItem(Crop.COCOA.getBrush());
            }
            case MELON: {
                return Items.field_151127_ba;
            }
            case NETHER_WART: {
                return Items.field_151075_bm;
            }
            case POTATOES: {
                return Items.field_151174_bG;
            }
            case PUMPKIN: {
                return Items.field_151080_bb;
            }
            case WHEAT: {
                return Items.field_151015_O;
            }
        }
        throw new CouldNotMapItemException(item);
    }

    private Item asItem(SingleBlockBrush brush) throws CouldNotMapItemException {
        try {
            return Item.func_150898_a((Block)BlockMapper1_12.map(brush).func_177230_c());
        }
        catch (CouldNotMapBlockException e) {
            throw new CouldNotMapItemException(brush.getBlockType().asItem(), (Exception)e);
        }
    }
}

