/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item.mapper;

import com.github.fnar.minecraft.item.Firework;
import com.github.fnar.minecraft.item.mapper.BaseItemMapper1_12;
import com.github.fnar.util.Color;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class FireworkMapper1_12
extends BaseItemMapper1_12<Firework> {
    private static NBTTagList mapExplosions(Firework firework) {
        NBTTagList explosionsTag = new NBTTagList();
        firework.getExplosions().stream().map(FireworkMapper1_12::mapExplosion).forEach(arg_0 -> ((NBTTagList)explosionsTag).func_74742_a(arg_0));
        return explosionsTag;
    }

    private static NBTTagCompound mapExplosion(Firework.Explosion explosion) {
        NBTTagCompound explosionTag = new NBTTagCompound();
        explosionTag.func_74774_a("Flicker", (byte)(explosion.hasFlicker() ? 1 : 0));
        explosionTag.func_74774_a("Trail", (byte)(explosion.hasTrail() ? 1 : 0));
        explosionTag.func_74774_a("Type", (byte)explosion.getShape().ordinal());
        explosionTag.func_74782_a("Colors", (NBTBase)new NBTTagIntArray(FireworkMapper1_12.mapColors(explosion.getColors())));
        return explosionTag;
    }

    private static int[] mapColors(List<Color> colors) {
        List colorsAsInt = colors.stream().map(Color::asInt).collect(Collectors.toList());
        int[] colorArr = new int[colorsAsInt.size()];
        for (int i = 0; i < colorsAsInt.size(); ++i) {
            colorArr[i] = (Integer)colorsAsInt.get(i);
        }
        return colorArr;
    }

    @Override
    public Class<Firework> getClazz() {
        return Firework.class;
    }

    @Override
    public ItemStack map(Firework firework) {
        NBTTagList explosionsTag = FireworkMapper1_12.mapExplosions(firework);
        NBTTagCompound fireworks = new NBTTagCompound();
        fireworks.func_74774_a("Flight", (byte)firework.getFlightLength().ordinal());
        fireworks.func_74782_a("Explosions", (NBTBase)explosionsTag);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Fireworks", (NBTBase)fireworks);
        ItemStack rocket = new ItemStack(Items.field_151152_bP);
        rocket.func_77982_d(tag);
        rocket = this.addEnchantmentNbtTags(firework, rocket);
        return rocket;
    }
}

