/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.commands;

import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.event.LevelUpEvent;
import codersafterdark.reskillable.api.toast.ToastHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CmdResetAll
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "resetall";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "reskillable.command.resetall.usage";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length == 0) {
            throw new CommandException("reskillable.command.invalid.missing.player", new Object[0]);
        }
        EntityPlayerMP player = CmdResetAll.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        Collection<PlayerSkillInfo> allSkils = data.getAllSkillInfo();
        StringBuilder failedSkills = new StringBuilder();
        for (PlayerSkillInfo skillInfo : allSkils) {
            int oldLevel = skillInfo.getLevel();
            if (!MinecraftForge.EVENT_BUS.post((Event)new LevelUpEvent.Pre((EntityPlayer)player, skillInfo.skill, 1, oldLevel))) {
                skillInfo.setLevel(1);
                skillInfo.respec();
                MinecraftForge.EVENT_BUS.post((Event)new LevelUpEvent.Post((EntityPlayer)player, skillInfo.skill, 1, oldLevel));
                ToastHelper.sendSkillToast(player, skillInfo.skill, 1);
                continue;
            }
            failedSkills.append(skillInfo.skill.getName()).append(", ");
        }
        data.saveAndSync();
        if (failedSkills.length() == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("reskillable.command.success.resetall", new Object[]{player.func_145748_c_()}));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("reskillable.command.fail.resetall", new Object[]{failedSkills.substring(0, failedSkills.length() - 2), player.func_145748_c_()}));
        }
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 0) {
            return Arrays.asList(server.func_184103_al().func_72369_d());
        }
        if (args.length == 1) {
            String partialName = args[0];
            return Arrays.stream(server.func_184103_al().func_72369_d()).filter(name -> name.startsWith(partialName)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public int func_82362_a() {
        return 2;
    }
}

