/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.client.base;

import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.api.requirement.AdvancementRequirement;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.SkillRequirement;
import codersafterdark.reskillable.base.LevelLockHandler;
import codersafterdark.reskillable.client.base.ClientTickHandler;
import codersafterdark.reskillable.client.base.RenderHelper;
import codersafterdark.reskillable.client.gui.GuiSkills;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HUDHandler {
    private static ItemStack lockedItem;
    private static String lockMessage;
    private static int lockTime;

    public static void setLockMessage(ItemStack item, String message) {
        lockedItem = item;
        lockMessage = message;
        lockTime = 40;
    }

    @SubscribeEvent
    public static void renderHUD(RenderGameOverlayEvent event) {
        if (lockTime > 0 && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            float transparency = 1.0f;
            if (lockTime < 10) {
                transparency = Math.max(0.05f, ((float)lockTime - ClientTickHandler.partialTicks) / 10.0f);
            }
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = event.getResolution();
            int width = res.func_78326_a();
            int height = res.func_78328_b();
            int y = height / 2 - 80;
            if (lockMessage.equals("reskillable.misc.locked.armor_equip")) {
                y -= 30;
            }
            int transparencyInt = (int)(255.0f * transparency) << 24;
            int color = (int)(17.0f * transparency) << 24;
            String msg = new TextComponentTranslation(lockMessage, new Object[0]).func_150261_e();
            int len = mc.field_71466_p.func_78256_a(msg);
            PlayerData data = PlayerDataHandler.get((EntityPlayer)mc.field_71439_g);
            RequirementHolder requirements = LevelLockHandler.getSkillLock(lockedItem);
            int pad = 26;
            int xp = width / 2 - requirements.getRestrictionLength() * pad / 2;
            ArrayList skillRequirements = Lists.newArrayList();
            ArrayList advancementRequirements = Lists.newArrayList();
            for (Requirement requirement : requirements.getRequirements()) {
                if (requirement instanceof SkillRequirement) {
                    skillRequirements.add((SkillRequirement)requirement);
                    continue;
                }
                if (!(requirement instanceof AdvancementRequirement)) continue;
                advancementRequirements.add((AdvancementRequirement)requirement);
            }
            int boxWidth = Math.max(pad * requirements.getRestrictionLength(), len) + 20;
            int boxHeight = 52 + advancementRequirements.size() * 10;
            Gui.func_73734_a((int)(width / 2 - boxWidth / 2), (int)(y - 10), (int)(width / 2 + boxWidth / 2), (int)(y + boxHeight), (int)color);
            Gui.func_73734_a((int)(width / 2 - boxWidth / 2 - 2), (int)(y - 12), (int)(width / 2 + boxWidth / 2 + 2), (int)(y + boxHeight + 2), (int)color);
            GlStateManager.func_179147_l();
            color = 16726336 + transparencyInt;
            mc.field_71466_p.func_175063_a(msg, (float)(res.func_78326_a() / 2 - len / 2), (float)y, color);
            for (SkillRequirement skillRequirement : skillRequirements) {
                int reqLevel = skillRequirement.getLevel();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                GuiSkills.drawSkill(xp, y + 18, skillRequirement.getSkill());
                int level = data.getSkillInfo(skillRequirement.getSkill()).getLevel();
                color = (level < reqLevel ? 16726336 : 3800973) + transparencyInt;
                mc.field_71466_p.func_175063_a(Integer.toString(reqLevel), (float)(xp + 8), (float)(y + 32), color);
                xp += pad;
            }
            int textLeft = xp;
            int textY = y + 48;
            color = 0xFFFFFF + transparencyInt;
            for (AdvancementRequirement advancementRequirement : advancementRequirements) {
                Advancement adv = advancementRequirement.getAdvancement();
                if (adv == null) continue;
                mc.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/advancements/widgets.png"));
                DisplayInfo display = adv.func_192068_c();
                int u = display.func_192291_d().func_192309_b();
                int v = 154;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                RenderHelper.drawTexturedModalRect(xp - 3, y + 17, 0.0f, u, v, 26, 26);
                GlStateManager.func_179140_f();
                GlStateManager.func_179089_o();
                net.minecraft.client.renderer.RenderHelper.func_74520_c();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(xp + 2), (float)(y + 22), (float)0.0f);
                if ((double)transparency > 0.5) {
                    mc.func_175599_af().func_180450_b(display.func_192298_b(), 0, 0);
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179140_f();
                mc.field_71466_p.func_175063_a(adv.func_193123_j().func_150260_c(), (float)textLeft, (float)textY, color);
                xp += pad;
                textY += 11;
            }
            GlStateManager.func_179121_F();
        }
    }

    public static void tick() {
        if (lockTime > 0) {
            --lockTime;
        }
    }
}

