/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.requirement;

import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.requirement.Requirement;
import codersafterdark.reskillable.api.requirement.RequirementComparision;
import codersafterdark.reskillable.api.skill.Skill;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class SkillRequirement
extends Requirement {
    private final Skill skill;
    private final int level;

    public SkillRequirement(Skill skill, int level) {
        this.skill = skill;
        this.level = level;
        this.tooltip = TextFormatting.GRAY + " - " + new TextComponentTranslation("reskillable.requirements.format.skill", new Object[]{TextFormatting.DARK_AQUA, skill.getName(), "%s", level}).func_150261_e();
    }

    @Override
    public boolean achievedByPlayer(EntityPlayer entityPlayer) {
        return PlayerDataHandler.get(entityPlayer).getSkillInfo(this.skill).getLevel() >= this.level;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public RequirementComparision matches(Requirement other) {
        if (other instanceof SkillRequirement) {
            SkillRequirement skillRequirement = (SkillRequirement)other;
            if (this.skill == null || skillRequirement.skill == null) {
                return RequirementComparision.NOT_EQUAL;
            }
            if (this.skill.getKey().equals(skillRequirement.skill.getKey())) {
                if (this.level == skillRequirement.level) {
                    return RequirementComparision.EQUAL_TO;
                }
                return this.level > skillRequirement.level ? RequirementComparision.GREATER_THAN : RequirementComparision.LESS_THAN;
            }
        }
        return RequirementComparision.NOT_EQUAL;
    }

    @Override
    public boolean isEnabled() {
        return this.skill != null && this.skill.isEnabled();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SkillRequirement) {
            SkillRequirement sReq = (SkillRequirement)o;
            return this.skill.equals(sReq.skill) && this.level == sReq.level;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.skill, this.level);
    }
}

