/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.data;

import codersafterdark.reskillable.api.data.FuzzyLockKey;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;

public abstract class NBTLockKey
implements FuzzyLockKey {
    protected NBTTagCompound tag;

    protected NBTLockKey(NBTTagCompound tag) {
        this.tag = tag == null || tag.func_82582_d() ? null : tag;
    }

    protected static boolean similarNBT(NBTBase full, NBTBase partial) {
        if (full == null) {
            return partial == null;
        }
        if (partial == null) {
            return true;
        }
        if (full.func_74732_a() != partial.func_74732_a()) {
            return false;
        }
        if (full.equals((Object)partial)) {
            return true;
        }
        switch (full.func_74732_a()) {
            case 10: {
                NBTTagCompound fullTag = (NBTTagCompound)full;
                NBTTagCompound partialTag = (NBTTagCompound)partial;
                Set ptKeys = partialTag.func_150296_c();
                for (String partialKey : ptKeys) {
                    if (fullTag.func_150297_b(partialKey, (int)partialTag.func_150299_b(partialKey)) && NBTLockKey.similarNBT(fullTag.func_74781_a(partialKey), partialTag.func_74781_a(partialKey))) continue;
                    return false;
                }
                return true;
            }
            case 9: {
                NBTTagList fTagList = (NBTTagList)full;
                NBTTagList pTagList = (NBTTagList)partial;
                if (fTagList.func_82582_d() && !pTagList.func_82582_d() || fTagList.func_150303_d() != pTagList.func_150303_d()) {
                    return false;
                }
                for (int i = 0; i < pTagList.func_74745_c(); ++i) {
                    NBTBase pTag = pTagList.func_179238_g(i);
                    boolean hasTag = false;
                    for (int j = 0; j < fTagList.func_74745_c(); ++j) {
                        if (!NBTLockKey.similarNBT(fTagList.func_179238_g(j), pTag)) continue;
                        hasTag = true;
                        break;
                    }
                    if (hasTag) continue;
                    return false;
                }
                return true;
            }
            case 7: {
                byte[] fByteArray = ((NBTTagByteArray)full).func_150292_c();
                byte[] pByteArray = ((NBTTagByteArray)partial).func_150292_c();
                ArrayList<Integer> hits = new ArrayList<Integer>();
                for (byte pByte : pByteArray) {
                    boolean hasMatch = false;
                    for (int i = 0; i < fByteArray.length; ++i) {
                        if (hits.contains(i) || pByte != fByteArray[i]) continue;
                        hits.add(i);
                        hasMatch = true;
                        break;
                    }
                    if (hasMatch) continue;
                    return false;
                }
                return true;
            }
            case 11: {
                int[] fIntArray = ((NBTTagIntArray)full).func_150302_c();
                int[] pIntArray = ((NBTTagIntArray)partial).func_150302_c();
                ArrayList<Integer> hits = new ArrayList<Integer>();
                for (int pInt : pIntArray) {
                    boolean hasMatch = false;
                    for (int i = 0; i < fIntArray.length; ++i) {
                        if (hits.contains(i) || pInt != fIntArray[i]) continue;
                        hits.add(i);
                        hasMatch = true;
                        break;
                    }
                    if (hasMatch) continue;
                    return false;
                }
                return true;
            }
            case 12: {
                long[] fLongArray = NBTLockKey.getLongArray((NBTTagLongArray)full);
                long[] pLongArray = NBTLockKey.getLongArray((NBTTagLongArray)partial);
                ArrayList<Integer> hits = new ArrayList<Integer>();
                for (long pLong : pLongArray) {
                    boolean hasMatch = false;
                    for (int i = 0; i < fLongArray.length; ++i) {
                        if (hits.contains(i) || pLong != fLongArray[i]) continue;
                        hits.add(i);
                        hasMatch = true;
                        break;
                    }
                    if (hasMatch) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static long[] getLongArray(NBTTagLongArray tag) {
        String t = tag.toString();
        String[] entries = t.substring(3, t.length() - 1).split(",");
        long[] data = new long[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            try {
                data[i] = Long.parseLong(entries[i].substring(0, entries[i].length() - 1));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return data;
    }

    public NBTTagCompound getTag() {
        return this.tag;
    }

    @Override
    public boolean isNotFuzzy() {
        return this.tag == null;
    }

    @Override
    public boolean fuzzyEquals(FuzzyLockKey other) {
        if (other == this) {
            return true;
        }
        if (other instanceof NBTLockKey) {
            return NBTLockKey.similarNBT((NBTBase)this.getTag(), (NBTBase)((NBTLockKey)other).getTag());
        }
        return false;
    }
}

