/*
 * Decompiled with CFR 0.152.
 */
package meldexun.reachfix.hook.client;

import java.util.List;
import javax.annotation.Nullable;
import meldexun.reachfix.config.ReachFixConfig;
import meldexun.reachfix.util.BoundingBoxUtil;
import meldexun.reachfix.util.ReachFixUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityRendererHook {
    public static void getMouseOver(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewEntity = mc.func_175606_aa();
        if (viewEntity == null) {
            return;
        }
        if (mc.field_71439_g == null) {
            return;
        }
        if (mc.field_71441_e == null) {
            return;
        }
        mc.field_71424_I.func_76320_a("pick");
        mc.field_71476_x = EntityRendererHook.pointedObject(viewEntity, (EntityPlayer)mc.field_71439_g, EnumHand.MAIN_HAND, (World)mc.field_71441_e, partialTicks);
        mc.field_71460_t.field_78528_u = mc.field_71476_x.field_72308_g;
        mc.field_147125_j = mc.field_71476_x.field_72308_g;
        mc.field_71424_I.func_76319_b();
    }

    public static RayTraceResult pointedObject(Entity viewEntity, EntityPlayer player, EnumHand hand, World world, float partialTicks) {
        Vec3d start = viewEntity.func_174824_e(partialTicks);
        Vec3d look = viewEntity.func_70676_i(partialTicks);
        double blockReach = ReachFixUtil.getBlockReach(player, hand);
        double entityReach = ReachFixUtil.getEntityReach(player, hand);
        Vec3d end = start.func_178787_e(look.func_186678_a(Math.max(blockReach, entityReach)));
        RayTraceResult pointedBlock = world.func_147447_a(start, end, false, false, false);
        RayTraceResult pointedEntity = EntityRendererHook.getPointedEntity(viewEntity, world, start, end, partialTicks);
        if (!EntityRendererHook.isNullOrMiss(pointedBlock)) {
            if (!EntityRendererHook.isNullOrMiss(pointedEntity)) {
                double distEntity;
                double distBlock = start.func_72436_e(pointedBlock.field_72307_f);
                if (distBlock < (distEntity = start.func_72436_e(pointedEntity.field_72307_f))) {
                    if (distBlock < blockReach * blockReach) {
                        return pointedBlock;
                    }
                } else if (distEntity < entityReach * entityReach) {
                    return pointedEntity;
                }
            } else if (start.func_72436_e(pointedBlock.field_72307_f) < blockReach * blockReach) {
                return pointedBlock;
            }
        } else if (!EntityRendererHook.isNullOrMiss(pointedEntity) && start.func_72436_e(pointedEntity.field_72307_f) < entityReach * entityReach) {
            return pointedEntity;
        }
        return new RayTraceResult(RayTraceResult.Type.MISS, end, null, new BlockPos(end));
    }

    @Nullable
    private static RayTraceResult getPointedEntity(Entity viewEntity, World world, Vec3d start, Vec3d end, float partialTicks) {
        AxisAlignedBB aabb = new AxisAlignedBB(start, end).func_186662_g(1.0);
        Entity lowestRidingEntity = viewEntity.func_184208_bv();
        List possibleEntities = world.func_175674_a(viewEntity, aabb, entity -> {
            if (!EntitySelectors.field_180132_d.apply(entity)) {
                return false;
            }
            return entity.func_70067_L();
        });
        RayTraceResult result = null;
        Entity pointedEntity = null;
        double min = Double.MAX_VALUE;
        for (Entity entity2 : possibleEntities) {
            double dist;
            AxisAlignedBB entityAabb = BoundingBoxUtil.getInteractionBoundingBox(entity2, partialTicks);
            if (lowestRidingEntity == entity2.func_184208_bv() && !entity2.canRiderInteract()) {
                if (!ReachFixConfig.getInstance().forceInteractionInsideVehicles || !entityAabb.func_72318_a(start)) continue;
                return new RayTraceResult(entity2, start);
            }
            if (entityAabb.func_72318_a(start)) {
                return new RayTraceResult(entity2, start);
            }
            RayTraceResult rtr = entityAabb.func_72327_a(start, end);
            if (EntityRendererHook.isNullOrMiss(rtr) || !((dist = start.func_72436_e(rtr.field_72307_f)) < min)) continue;
            result = rtr;
            pointedEntity = entity2;
            min = dist;
        }
        if (EntityRendererHook.isNullOrMiss(result)) {
            return null;
        }
        return new RayTraceResult(pointedEntity, result.field_72307_f);
    }

    private static boolean isNullOrMiss(RayTraceResult rayTraceResult) {
        return rayTraceResult == null || rayTraceResult.field_72313_a == RayTraceResult.Type.MISS;
    }
}

