/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.mixin.bettersurvival;

import com.mujmajnkraft.bettersurvival.capabilities.nunchakucombo.INunchakuCombo;
import com.mujmajnkraft.bettersurvival.capabilities.nunchakucombo.NunchakuComboProvider;
import com.mujmajnkraft.bettersurvival.config.ForgeConfigHandler;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentAgility;
import com.mujmajnkraft.bettersurvival.enchantments.EnchantmentVitality;
import com.mujmajnkraft.bettersurvival.eventhandlers.CommonEventHandler;
import com.mujmajnkraft.bettersurvival.init.ModEnchantments;
import com.mujmajnkraft.bettersurvival.init.ModPotions;
import com.mujmajnkraft.bettersurvival.items.ItemCustomShield;
import com.mujmajnkraft.bettersurvival.items.ItemNunchaku;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={CommonEventHandler.class})
public abstract class CommonEventHandlerMixin {
    private static final UUID followUUID = UUID.fromString("a6107045-134f-4c14-a645-75c3ae5c7a27");
    private static final AttributeModifier SHIELD_KNOCKBACK = new AttributeModifier(ItemCustomShield.knockbackModifierUUID, "shield_knockback_adjustment", 0.0, 0);
    private static final AttributeModifier SHIELD_WEIGHT = new AttributeModifier(ItemCustomShield.weightModifierUUID, "shield_speed_adjustment", 0.0, 0);
    private static final AttributeModifier AGILITY = new AttributeModifier(EnchantmentAgility.speedModifier, "agility", 0.0, 0);
    private static final AttributeModifier BLIND = new AttributeModifier(followUUID, "blind", 0.0, 1);

    @Overwrite(remap=false)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            int vitLvl;
            INunchakuCombo combo;
            if (entity.func_184614_ca().func_77973_b() instanceof ItemNunchaku && (combo = (INunchakuCombo)entity.getCapability(NunchakuComboProvider.NUNCHAKUCOMBO_CAP, null)) != null && (combo.getComboTime() > 0 || combo.getComboPower() > 0.0f)) {
                combo.countDown();
            }
            if ((vitLvl = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.vitality, (EntityLivingBase)entity)) > 0) {
                EnchantmentVitality.healPlayer((EntityPlayer)((EntityPlayer)entity), (int)vitLvl);
            }
            IAttributeInstance movSpeed = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (entity.func_184607_cu().func_77973_b() instanceof ItemCustomShield) {
                ((ItemCustomShield)entity.func_184607_cu().func_77973_b()).applyModifiers(entity);
            } else if (movSpeed.func_180374_a(SHIELD_KNOCKBACK) || movSpeed.func_180374_a(SHIELD_WEIGHT)) {
                movSpeed.func_188479_b(ItemCustomShield.knockbackModifierUUID);
                movSpeed.func_188479_b(ItemCustomShield.weightModifierUUID);
            }
            int speedLvl = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantments.agility, (EntityLivingBase)entity);
            if (speedLvl > 0) {
                EnchantmentAgility.applySpeedModifier((EntityLivingBase)entity, (int)speedLvl);
            } else if (movSpeed.func_180374_a(AGILITY)) {
                movSpeed.func_188479_b(EnchantmentAgility.speedModifier);
            }
        }
        if (entity.func_70660_b(ModPotions.stun) != null) {
            entity.field_70159_w = 0.0;
            if (entity.field_70181_x > 0.0) {
                entity.field_70181_x = 0.0;
            }
            entity.field_70179_y = 0.0;
            if (entity instanceof EntityCreeper) {
                ((EntityCreeper)entity).func_70829_a(-1);
            }
        }
        if (entity instanceof EntityLiving) {
            double strength;
            EntityEntry entry;
            IAttributeInstance follow = entity.func_110148_a(SharedMonsterAttributes.field_111265_b);
            if (follow.func_180374_a(BLIND)) {
                follow.func_188479_b(followUUID);
            }
            if (entity.func_70660_b(MobEffects.field_76440_q) != null && (entry = EntityRegistry.getEntry(entity.getClass())) != null && !Arrays.asList(ForgeConfigHandler.potions.blindnessBlacklist).contains(entry.getRegistryName().toString()) && (strength = -0.01 * ForgeConfigHandler.potions.blindnessStrength) < 0.0) {
                AttributeModifier modifier = new AttributeModifier(followUUID, "blind", strength, 1);
                follow.func_111121_a(modifier);
            }
        }
    }
}

