/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class PotionSpecific
extends LootFunction {
    private final PotionType potionType;
    private final List<PotionEffect> potionEffects;

    public PotionSpecific(LootCondition[] conditionsIn, PotionType potionType, List<PotionEffect> potionEffects) {
        super(conditionsIn);
        this.potionType = potionType;
        this.potionEffects = potionEffects;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (this.potionType == null && (this.potionEffects == null || this.potionEffects.isEmpty())) {
            return stack;
        }
        if (stack.func_77973_b() == Items.field_151032_g) {
            stack = new ItemStack(Items.field_185167_i, stack.func_190916_E());
        } else if (stack.func_77973_b() == Items.field_151069_bo) {
            stack = new ItemStack((Item)Items.field_151068_bn);
        }
        if (this.potionType != null) {
            PotionUtils.func_185188_a((ItemStack)stack, (PotionType)this.potionType);
        }
        if (this.potionEffects != null && !this.potionEffects.isEmpty()) {
            PotionUtils.func_185184_a((ItemStack)stack, this.potionEffects);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<PotionSpecific> {
        public Serializer() {
            super(new ResourceLocation("rlmixins:potion_specific"), PotionSpecific.class);
        }

        public void serialize(JsonObject object, PotionSpecific functionClazz, JsonSerializationContext serializationContext) {
            if (functionClazz.potionType != null) {
                ResourceLocation loc = (ResourceLocation)PotionType.field_185176_a.func_177774_c((Object)functionClazz.potionType);
                object.add("potionType", (JsonElement)new JsonPrimitive(loc.toString()));
            }
            if (functionClazz.potionEffects != null && !functionClazz.potionEffects.isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (PotionEffect potionEffect : functionClazz.potionEffects) {
                    ResourceLocation loc = (ResourceLocation)Potion.field_188414_b.func_177774_c((Object)potionEffect.func_188419_a());
                    if (loc == null) {
                        throw new IllegalArgumentException("Don't know how to serialize potion " + potionEffect);
                    }
                    JsonObject obj = new JsonObject();
                    obj.add("potion", (JsonElement)new JsonPrimitive(loc.toString()));
                    obj.addProperty("amplifier", (Number)potionEffect.func_76458_c());
                    obj.addProperty("duration", (Number)potionEffect.func_76459_b());
                    obj.addProperty("ambient", Boolean.valueOf(potionEffect.func_82720_e()));
                    obj.addProperty("showParticles", Boolean.valueOf(potionEffect.func_188418_e()));
                    jsonarray.add((JsonElement)obj);
                }
                object.add("potionEffects", (JsonElement)jsonarray);
            }
        }

        public PotionSpecific deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            PotionType potionType = null;
            if (object.has("potionType")) {
                String s = JsonUtils.func_151200_h((JsonObject)object, (String)"potionType");
                potionType = (PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation(s));
            }
            ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
            if (object.has("potionEffects")) {
                for (JsonElement element : JsonUtils.func_151214_t((JsonObject)object, (String)"potionEffects")) {
                    if (!(element instanceof JsonObject)) continue;
                    JsonObject object1 = (JsonObject)element;
                    String s = JsonUtils.func_151200_h((JsonObject)object1, (String)"potion");
                    Potion potion = (Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(s));
                    if (potion == null) {
                        throw new JsonSyntaxException("Unknown potion '" + s + "'");
                    }
                    int amplifier = JsonUtils.func_151208_a((JsonObject)object1, (String)"amplifier", (int)0);
                    int duration = JsonUtils.func_151208_a((JsonObject)object1, (String)"duration", (int)0);
                    boolean ambient = JsonUtils.func_151209_a((JsonObject)object1, (String)"ambient", (boolean)false);
                    boolean showParticles = JsonUtils.func_151209_a((JsonObject)object1, (String)"showParticles", (boolean)true);
                    potionEffects.add(new PotionEffect(potion, amplifier, duration, ambient, showParticles));
                }
            }
            return new PotionSpecific(conditionsIn, potionType, potionEffects);
        }
    }
}

