/*
 * Decompiled with CFR 0.152.
 */
package rlmixins.entity.flare;

import cursedflames.bountifulbaubles.util.Util;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rlmixins.RLMixins;

public class EntityFlareNonAlbedo
extends EntityArrow {
    protected boolean inGround;
    protected BlockPos tilePos;
    protected Block inTile;
    protected double tileX;
    protected double tileY;
    protected double tileZ;
    protected int xTile;
    protected int yTile;
    protected int zTile;
    protected int ticksInGround = 0;
    private boolean isPlayingSound = false;

    public EntityFlareNonAlbedo(World world) {
        super(world);
    }

    public EntityFlareNonAlbedo(World world, double x, double y, double z) {
        super(world);
        this.func_70107_b(x, y, z);
    }

    public EntityFlareNonAlbedo(World world, EntityLivingBase thrower) {
        this(world, thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e() - (double)0.1f, thrower.field_70161_v);
        this.field_70250_c = thrower;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        double f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= f;
        y /= f;
        z /= f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        double f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void shoot(EntityLivingBase entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        this.field_70250_c = entityThrower;
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += entityThrower.field_70159_w;
        this.field_70179_y += entityThrower.field_70179_y;
        if (!entityThrower.field_70122_E) {
            this.field_70181_x += entityThrower.field_70181_x;
        }
    }

    protected void func_184548_a(EntityLivingBase entity) {
        if (!(entity instanceof EntityEnderman)) {
            entity.func_70015_d(5);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.inGround = compound.func_74767_n("inGround");
        if (compound.func_74764_b("tilePos")) {
            NBTTagCompound pos = compound.func_74775_l("tilePos");
            this.tilePos = Util.blockPosFromNBT((NBTTagCompound)pos);
        }
        if (compound.func_150297_b("inTile", 8)) {
            this.inTile = Block.func_149684_b((String)compound.func_74779_i("inTile"));
        }
        if (compound.func_186855_b("thrower")) {
            UUID thrower = compound.func_186857_a("thrower");
            this.field_70250_c = this.field_70170_p.func_152378_a(thrower);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        ResourceLocation resourcelocation;
        compound.func_74757_a("inGround", this.inGround);
        if (this.tilePos != null) {
            NBTTagCompound pos = Util.blockPosToNBT((BlockPos)this.tilePos);
            compound.func_74782_a("tilePos", (NBTBase)pos);
        }
        compound.func_74778_a("inTile", (resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile)) == null ? "" : resourcelocation.toString());
        if (this.field_70250_c != null) {
            compound.func_186854_a("thrower", this.field_70250_c.func_110124_au());
        }
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    public void func_70071_h_() {
        int particleRate;
        super.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        int n = particleRate = this.inGround ? 10 : 2;
        if (this.field_70170_p.field_72995_K) {
            Vec3d vel = new Vec3d(0.0, 0.0, -1.0).func_178789_a((float)((double)this.field_70125_A * (Math.PI / 180))).func_178785_b((float)((double)this.field_70177_z * (Math.PI / 180)));
            if (this.field_70170_p.func_82737_E() % (long)particleRate == 0L) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + vel.field_72450_a * 0.3, this.field_70163_u + vel.field_72448_b * 0.3, this.field_70161_v + vel.field_72449_c * 0.3, vel.field_72450_a * 0.055, vel.field_72448_b * 0.055, vel.field_72449_c * 0.055, new int[0]);
            }
            if (!this.isPlayingSound) {
                this.isPlayingSound = true;
                RLMixins.PROXY.playSoundFlare(this);
            }
        }
        if (this.field_70173_aa > 6000) {
            this.func_70106_y();
        }
        if (this.inGround && this.tilePos != null) {
            if (this.field_70170_p.func_180495_p(this.tilePos).func_177230_c() == this.inTile) {
                ++this.ticksInGround;
                return;
            }
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
        }
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d, vec3d1, false, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult1;
            if (!entity1.func_70067_L() || entity1 == this.field_70250_c && this.field_70173_aa < 5 || (raytraceresult1 = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(raytraceresult.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(raytraceresult.func_178782_a());
            } else if (!ForgeEventFactory.onProjectileImpact((EntityArrow)this, (RayTraceResult)raytraceresult)) {
                this.func_184549_a(raytraceresult);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        double velMultiplier = 0.995;
        float gravity = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            velMultiplier = 0.8;
        }
        this.field_70159_w *= velMultiplier;
        this.field_70181_x *= velMultiplier;
        this.field_70179_y *= velMultiplier;
        if (!this.func_189652_ae()) {
            if (this.field_70181_x > 0.0) {
                this.field_70181_x -= (double)gravity;
            } else {
                double preY = this.field_70181_x;
                this.field_70181_x -= (double)gravity / 8.0;
                this.field_70159_w *= 0.95;
                this.field_70181_x *= 1.01;
                this.field_70179_y *= 0.95;
                if (this.field_70181_x - preY > (double)(gravity / 4.0f)) {
                    this.field_70181_x = preY - (double)(gravity / 4.0f);
                }
            }
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.inGround) {
            // empty if block
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            float f;
            int i;
            if (entity.field_70170_p.field_72995_K && this.field_70173_aa < 5) {
                return;
            }
            DamageSource damagesource = this.field_70250_c == null ? DamageSource.func_76353_a((EntityArrow)this, (Entity)this) : DamageSource.func_76353_a((EntityArrow)this, (Entity)this.field_70250_c);
            if (entity.func_70097_a(damagesource, (float)(i = MathHelper.func_76143_f((double)((double)(f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y))) * 0.5))))) {
                if (entity instanceof EntityLivingBase) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    this.func_184548_a(entitylivingbase);
                    if (this.field_70250_c != null && entitylivingbase != this.field_70250_c && entitylivingbase instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundEvents.field_187649_bu, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            }
            this.field_70159_w *= (double)-0.1f;
            this.field_70181_x *= (double)-0.1f;
            this.field_70179_y *= (double)-0.1f;
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
        } else {
            BlockPos blockpos;
            this.tilePos = blockpos = raytraceResultIn.func_178782_a();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.inTile = iblockstate.func_177230_c();
            this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.inGround = true;
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.inTile.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
                if (this.ticksInGround < 120 && this.field_70170_p.func_175623_d(this.tilePos.func_177972_a(raytraceResultIn.field_178784_b))) {
                    this.field_70170_p.func_180501_a(this.tilePos.func_177972_a(raytraceResultIn.field_178784_b), Blocks.field_150480_ab.func_176223_P(), 11);
                }
            }
        }
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }
}

