/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.util;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import meldexun.reachfix.config.ReachFixConfig;
import meldexun.reachfix.hook.client.EntityRendererHook;
import meldexun.reachfix.util.BoundingBoxUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class ReachFixUtil {
    public static RayTraceResult pointedObject(Entity viewEntity, EntityPlayer player, EnumHand hand, World world, float partialTicks) {
        return EntityRendererHook.pointedObject((Entity)viewEntity, (EntityPlayer)player, (EnumHand)hand, (World)world, (float)partialTicks);
    }

    public static RayTraceResult pointedObjectIgnorePassable(Entity viewEntity, EntityPlayer player, EnumHand hand, World world, float partialTicks) {
        Vec3d start = viewEntity.func_174824_e(partialTicks);
        Vec3d look = viewEntity.func_70676_i(partialTicks);
        double blockReach = meldexun.reachfix.util.ReachFixUtil.getBlockReach((EntityPlayer)player, (EnumHand)hand);
        double entityReach = meldexun.reachfix.util.ReachFixUtil.getEntityReach((EntityPlayer)player, (EnumHand)hand);
        Vec3d end = start.func_178787_e(look.func_186678_a(Math.max(blockReach, entityReach)));
        RayTraceResult pointedBlock = world.func_147447_a(start, end, false, true, false);
        RayTraceResult pointedEntity = ReachFixUtil.getPointedEntity(viewEntity, world, start, end, partialTicks);
        if (!ReachFixUtil.isNullOrMiss(pointedBlock)) {
            if (!ReachFixUtil.isNullOrMiss(pointedEntity)) {
                double distEntity;
                double distBlock = start.func_72436_e(pointedBlock.field_72307_f);
                if (distBlock < (distEntity = start.func_72436_e(pointedEntity.field_72307_f))) {
                    if (distBlock < blockReach * blockReach) {
                        return pointedBlock;
                    }
                } else if (distEntity < entityReach * entityReach) {
                    return pointedEntity;
                }
            } else if (start.func_72436_e(pointedBlock.field_72307_f) < blockReach * blockReach) {
                return pointedBlock;
            }
        } else if (!ReachFixUtil.isNullOrMiss(pointedEntity) && start.func_72436_e(pointedEntity.field_72307_f) < entityReach * entityReach) {
            return pointedEntity;
        }
        return new RayTraceResult(RayTraceResult.Type.MISS, end, (EnumFacing)null, new BlockPos(end));
    }

    @Nullable
    private static RayTraceResult getPointedEntity(Entity viewEntity, World world, Vec3d start, Vec3d end, float partialTicks) {
        Entity entity;
        AxisAlignedBB aabb = new AxisAlignedBB(start, end).func_186662_g(1.0);
        Entity lowestRidingEntity = viewEntity.func_184208_bv();
        List possibleEntities = world.func_175674_a(viewEntity, aabb, entityx -> !EntitySelectors.field_180132_d.apply(entityx) ? false : entityx.func_70067_L());
        RayTraceResult result = null;
        Entity pointedEntity = null;
        double min = Double.MAX_VALUE;
        Iterator var12 = possibleEntities.iterator();
        while (true) {
            AxisAlignedBB entityAabb;
            if (var12.hasNext()) {
                entity = (Entity)var12.next();
                entityAabb = BoundingBoxUtil.getInteractionBoundingBox((Entity)entity, (float)partialTicks);
                if (lowestRidingEntity != entity.func_184208_bv() || entity.canRiderInteract()) {
                    double dist;
                    if (entityAabb.func_72318_a(start)) {
                        return new RayTraceResult(entity, start);
                    }
                    RayTraceResult rtr = entityAabb.func_72327_a(start, end);
                    if (ReachFixUtil.isNullOrMiss(rtr) || !((dist = start.func_72436_e(rtr.field_72307_f)) < min)) continue;
                    result = rtr;
                    pointedEntity = entity;
                    min = dist;
                    continue;
                }
            } else {
                if (ReachFixUtil.isNullOrMiss(result)) {
                    return null;
                }
                return new RayTraceResult(pointedEntity, result.field_72307_f);
            }
            if (ReachFixConfig.getInstance().forceInteractionInsideVehicles && entityAabb.func_72318_a(start)) break;
        }
        return new RayTraceResult(entity, start);
    }

    private static boolean isNullOrMiss(RayTraceResult rayTraceResult) {
        return rayTraceResult == null || rayTraceResult.field_72313_a == RayTraceResult.Type.MISS;
    }
}

