/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.client.animation.util;

import bettercombat.mod.client.animation.util.AnimationEnum;
import bettercombat.mod.client.animation.util.CustomWeapon;
import bettercombat.mod.client.animation.util.IAnimation;
import bettercombat.mod.mixin.IEntityLivingBaseMixin;
import bettercombat.mod.util.ConfigurationHandler;
import java.util.Random;
import net.minecraft.client.Minecraft;

public class BetterCombatHand {
    CustomWeapon customWeapon = null;
    public IAnimation activeAttackAnimation;
    public IAnimation activeMiningAnimation;
    public int equipSoundTimer = 0;
    public float swingTimestampSound = 0.0f;
    private boolean isSwingInProgress = false;
    private int swingProgressInt = 0;
    private float swingProgressFloat = 0.0f;
    private float prevSwingProgressFloat = 0.0f;
    public static int minimumCooldownTicks = 4;
    public static int maximumCooldownTicks = 15;
    public int attackCooldown = minimumCooldownTicks;
    public int sprintingTimer = 0;
    public int sprintingTimerPrev = 0;
    public float moveRightVariance = 1.0f;
    public float moveUpVariance = 1.0f;
    public float moveCloseVariance = 1.0f;
    public float rotateUpVariance = 1.0f;
    public float rotateCounterClockwiseVariance = 1.0f;
    public float rotateLeftVariance = 1.0f;
    public boolean firstRaise = false;
    private final Random rand = new Random();

    public BetterCombatHand() {
        this.resetBetterCombatWeapon();
    }

    public void setBetterCombatWeapon(CustomWeapon customWeapon, int cooldownTicks) {
        this.customWeapon = customWeapon;
        this.equipSoundTimer = cooldownTicks / 2;
        this.activeAttackAnimation = this.getAttackAnimationEnum().getAnimation();
        this.activeMiningAnimation = this.getMiningAnimationEnum().getAnimation();
        this.firstRaise = true;
    }

    public void tick() {
        int i = Math.max(((IEntityLivingBaseMixin)Minecraft.func_71410_x().field_71439_g).invokeGetArmSwingAnimationEnd(), 1);
        this.prevSwingProgressFloat = this.swingProgressFloat;
        if (this.isSwingInProgress) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= i) {
                this.swingProgressInt = 0;
                this.isSwingInProgress = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgressFloat = (float)this.swingProgressInt / (float)i;
        this.sprintingTimerPrev = this.sprintingTimer;
        if (Minecraft.func_71410_x().field_71439_g.func_70051_ag() && !(this.swingProgressFloat > 0.0f)) {
            if (this.sprintingTimer < 20 && ConfigurationHandler.client.sprintingWeaponTilt) {
                this.sprintingTimer += 5;
            }
        } else if (this.sprintingTimer > 0) {
            this.sprintingTimer -= 5;
            if (this.sprintingTimer > 0 && this.swingProgressFloat > 0.0f) {
                this.sprintingTimer -= 5;
            }
        }
    }

    public void swingHand() {
        if (!this.isSwingInProgress || this.swingProgressInt >= ((IEntityLivingBaseMixin)Minecraft.func_71410_x().field_71439_g).invokeGetArmSwingAnimationEnd() / 2 || this.swingProgressInt < 0) {
            this.swingProgressInt = -1;
            this.isSwingInProgress = true;
        }
    }

    public float getSwingProgress(float partialTick) {
        float f = this.swingProgressFloat - this.prevSwingProgressFloat;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.prevSwingProgressFloat + f * partialTick;
    }

    private CustomWeapon getCustomWeapon() {
        return this.customWeapon;
    }

    public boolean hasCustomWeapon() {
        return this.customWeapon != null;
    }

    public CustomWeapon.WeaponProperty getWeaponProperty() {
        if (this.hasCustomWeapon()) {
            return this.getCustomWeapon().property;
        }
        return CustomWeapon.WeaponProperty.ONEHAND;
    }

    public AnimationEnum getAttackAnimationEnum() {
        if (this.hasCustomWeapon()) {
            return this.getCustomWeapon().attackAnimation;
        }
        return AnimationEnum.PUNCH;
    }

    public AnimationEnum getMiningAnimationEnum() {
        if (this.hasCustomWeapon()) {
            return this.getCustomWeapon().miningAnimation;
        }
        return AnimationEnum.PUNCH;
    }

    public IAnimation getActiveAttackAnimation() {
        return this.activeAttackAnimation != null ? this.activeAttackAnimation : AnimationEnum.PUNCH.getAnimation();
    }

    public IAnimation getActiveMiningAnimation() {
        return this.activeMiningAnimation != null ? this.activeMiningAnimation : AnimationEnum.PUNCH.getAnimation();
    }

    public CustomWeapon.SoundType getSoundType() {
        if (this.hasCustomWeapon()) {
            return this.getCustomWeapon().soundType;
        }
        return CustomWeapon.SoundType.DEFAULT;
    }

    public void resetBetterCombatWeapon() {
        this.customWeapon = null;
        this.isSwingInProgress = false;
        this.swingProgressInt = 0;
        this.swingProgressFloat = 0.0f;
        this.prevSwingProgressFloat = 0.0f;
        this.equipSoundTimer = 0;
        this.swingTimestampSound = 0.0f;
        this.activeAttackAnimation = AnimationEnum.PUNCH.getAnimation();
        this.activeMiningAnimation = AnimationEnum.PUNCH.getAnimation();
        this.firstRaise = false;
    }

    public void randomizeVariances() {
        this.moveRightVariance = this.randomMoveVariance();
        this.moveUpVariance = this.randomMoveVariance();
        this.moveCloseVariance = this.randomMoveVariance();
        this.rotateUpVariance = this.randomRotationVariance();
        this.rotateCounterClockwiseVariance = this.randomRotationVariance();
        this.rotateLeftVariance = this.randomRotationVariance();
    }

    public float randomMoveVariance() {
        return 1.06f - this.rand.nextFloat() * 0.12f;
    }

    public float randomRotationVariance() {
        return 1.03f - this.rand.nextFloat() * 0.06f;
    }

    public float randomPreciseRotationVariance() {
        return 1.015f - this.rand.nextFloat() * 0.03f;
    }

    public boolean soundReady() {
        if (this.swingTimestampSound < this.getSwingProgress(1.0f) && this.swingTimestampSound != 0.0f) {
            this.swingTimestampSound = 0.0f;
            return true;
        }
        return false;
    }

    public void setSwingTimestampSound(float timeStamp) {
        this.swingTimestampSound = timeStamp;
    }

    public void initiateAnimation() {
        if (this.hasCustomWeapon()) {
            this.activeAttackAnimation = this.getAttackAnimationEnum().getAnimation();
            this.activeMiningAnimation = this.getMiningAnimationEnum().getAnimation();
            this.getActiveAttackAnimation().setActive(this);
        } else {
            this.activeAttackAnimation = AnimationEnum.PUNCH.getAnimation();
            this.activeMiningAnimation = AnimationEnum.PUNCH.getAnimation();
            this.getActiveAttackAnimation().setActive(this);
        }
        this.swingHand();
        this.firstRaise = false;
    }
}

