/*
 * Decompiled with CFR 0.152.
 */
package bettercombat.mod.client.animation;

import bettercombat.mod.client.animation.util.BetterCombatHand;
import bettercombat.mod.client.animation.util.IAnimation;
import bettercombat.mod.client.handler.AnimationHandler;
import bettercombat.mod.client.handler.EventHandlersClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;

public class AnimationSweep
implements IAnimation {
    @Override
    public void animationMainhand(boolean rightHanded, float swingProgress, float partialTick) {
        this.animateSwing(rightHanded, swingProgress, partialTick, EventHandlersClient.betterCombatMainhand);
    }

    @Override
    public void animationOffhand(boolean rightHanded, float swingProgress, float partialTick) {
        this.animateSwing(!rightHanded, swingProgress, partialTick, EventHandlersClient.betterCombatOffhand);
    }

    @Override
    public void setActive(BetterCombatHand hand) {
        hand.setSwingTimestampSound(0.6f);
        hand.moveRightVariance = hand.randomMoveVariance();
        hand.moveUpVariance = hand.randomMoveVariance();
        hand.moveCloseVariance = hand.randomMoveVariance();
        hand.rotateUpVariance = hand.randomPreciseRotationVariance();
        hand.rotateCounterClockwiseVariance = hand.randomRotationVariance();
        hand.rotateLeftVariance = hand.randomRotationVariance();
    }

    private void animateSwing(boolean rightHanded, float swingProgress, float partialTick, BetterCombatHand hand) {
        int i = rightHanded ? 1 : -1;
        float moveRight = 0.0f;
        float moveUp = 0.0f;
        float moveClose = 0.0f;
        float rotateUp = 0.0f;
        float rotateCounterClockwise = 0.0f;
        float rotateLeft = 0.0f;
        float closeCap = 0.4f - (AnimationHandler.lastTooCloseAmount + (AnimationHandler.tooCloseAmount - AnimationHandler.lastTooCloseAmount) * partialTick);
        rotateUp = -AnimationHandler.minMult(swingProgress, 6.0f, 140.0f + closeCap * 50.0f);
        rotateCounterClockwise = AnimationHandler.minMult(swingProgress, 12.0f, 150.0f) - AnimationHandler.minMult(swingProgress, 3.0f, 50.0f + closeCap * 100.0f) - swingProgress * 15.0f;
        rotateLeft = AnimationHandler.minMult(swingProgress, 6.0f, 85.0f);
        moveRight = AnimationHandler.minMult(swingProgress, 12.0f, 3.5f) + 0.5f;
        moveUp = AnimationHandler.min(swingProgress * 10.0f, 0.47f);
        moveClose = -AnimationHandler.min(swingProgress * 10.0f, closeCap);
        if (swingProgress > 0.6f) {
            moveRight -= 4.5f + closeCap - (1.0f - MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI))) * 0.3f;
            if (swingProgress > 0.85f) {
                moveUp -= MathHelper.func_76126_a((float)(swingProgress - 0.85f)) * 6.0f;
                moveClose += MathHelper.func_76126_a((float)(swingProgress - 0.85f)) * 6.0f;
                moveRight += (swingProgress - 0.85f) * 5.5f;
            }
        } else {
            moveRight -= AnimationHandler.min(MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI)) * 5.5f, 4.5f + closeCap);
        }
        GlStateManager.func_179109_b((float)(1.2f * (float)i * moveRight * hand.moveRightVariance), (float)(1.1f * moveUp * hand.moveUpVariance), (float)(moveClose * hand.moveCloseVariance));
        GlStateManager.func_179114_b((float)(rotateUp * hand.rotateUpVariance), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * rotateCounterClockwise * hand.rotateCounterClockwiseVariance), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * rotateLeft * hand.rotateLeftVariance), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    @Override
    public float getCameraPitchMult() {
        return 0.5f;
    }

    @Override
    public float getCameraYawMult() {
        return 1.5f;
    }
}

