/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.arl.util.RotationHandler;
import vazkii.quark.base.handler.DimensionConfig;
import vazkii.quark.world.feature.BrokenNetherPortals;

public class BrokenPortalGenerator
implements IWorldGenerator {
    private final DimensionConfig dims;

    public BrokenPortalGenerator(DimensionConfig dims) {
        this.dims = dims;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!this.dims.canSpawnHere(world) || random.nextDouble() > BrokenNetherPortals.chance) {
            return;
        }
        int x = chunkX * 16 + 8 + random.nextInt(16);
        int z = chunkZ * 16 + 8 + random.nextInt(16);
        int y = random.nextInt(100) + 20;
        BlockPos pos = new BlockPos(x, y, z);
        while (world.func_175623_d(pos)) {
            if ((pos = pos.func_177977_b()).func_177956_o() < 10) {
                return;
            }
            if (!world.func_175665_u(pos)) continue;
            BrokenPortalGenerator.makeBrokenPortal(world, pos.func_177984_a());
            break;
        }
    }

    public static void makeBrokenPortal(World world, BlockPos pos) {
        int[] xz;
        Rotation rot = Rotation.values()[world.field_73012_v.nextInt(Rotation.values().length)];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 5; ++j) {
                xz = RotationHandler.applyRotation((Rotation)rot, (int)i, (int)0);
                BlockPos testPos = pos.func_177982_a(xz[0], j, xz[1]);
                if (world.func_175623_d(testPos)) continue;
                return;
            }
        }
        IBlockState obsidian = Blocks.field_150343_Z.func_176223_P();
        for (int i = 0; i < 4; ++i) {
            xz = RotationHandler.applyRotation((Rotation)rot, (int)i, (int)0);
            BlockPos placePos = pos.func_177982_a(xz[0], 0, xz[1]);
            world.func_175656_a(placePos, obsidian);
        }
        int count = 2 + world.field_73012_v.nextInt(3);
        int placed = 4 + count;
        for (int i = 0; i < count; ++i) {
            BlockPos placePos = pos.func_177982_a(0, i + 1, 0);
            world.func_175656_a(placePos, obsidian);
        }
        count = 2 + world.field_73012_v.nextInt(3);
        placed += count;
        int[] xz2 = RotationHandler.applyRotation((Rotation)rot, (int)3, (int)0);
        for (int i = 0; i < count; ++i) {
            BlockPos placePos = pos.func_177982_a(xz2[0], i + 1, xz2[1]);
            world.func_175656_a(placePos, obsidian);
        }
        int missing = 13 - placed;
        int spread = 3;
        xz2 = RotationHandler.applyRotation((Rotation)rot, (int)1, (int)0);
        block5: for (int i = 0; i < missing; ++i) {
            block6: for (int tries = 0; tries < 20; ++tries) {
                BlockPos tryPos = pos.func_177982_a(xz2[0] + world.field_73012_v.nextInt(spread * 2) - spread, 3, xz2[1] + world.field_73012_v.nextInt(spread * 2) - spread);
                if (!world.func_175623_d(tryPos)) continue;
                while (world.func_175623_d(tryPos)) {
                    if ((tryPos = tryPos.func_177977_b()).func_177956_o() >= 2) continue;
                    continue block6;
                }
                world.func_175656_a(tryPos.func_177984_a(), obsidian);
                continue block5;
            }
        }
    }
}

