/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButtonImage;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.RecipeToast;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.module.Feature;

public class AutomaticRecipeUnlock
extends Feature {
    public static List<String> ignored;
    public static boolean forceLimitedCrafting;
    public static boolean disableRecipeBook;

    @Override
    public void setupConfig() {
        String[] ignoredArr = this.loadPropStringList("Ignored Recipes", "A list of recipe names that should NOT be added in by default", new String[0]);
        ignored = Arrays.asList(ignoredArr);
        forceLimitedCrafting = this.loadPropBool("Force Limited Crafting", "Set to true to force the doLimitedCrafting gamerule to true.\nCombine this with the Ignored Recipes list to create a system where only a few selected recipes are locked.", false);
        disableRecipeBook = this.loadPropBool("Disable Recipe Book", "Set this to true to disable the vanilla recipe book altogether.", false);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            ArrayList recipes = Lists.newArrayList((Iterable)CraftingManager.field_193380_a);
            recipes.removeIf(recipe -> ignored.contains(Objects.toString(recipe.getRegistryName())) || recipe.func_77571_b().func_190926_b());
            event.player.func_192021_a((List)recipes);
            if (forceLimitedCrafting) {
                event.player.field_70170_p.func_82736_K().func_82764_b("doLimitedCrafting", "true");
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (disableRecipeBook && (gui instanceof GuiInventory || gui instanceof GuiCrafting)) {
            Minecraft.func_71410_x().field_71439_g.func_192035_E().func_192813_a(false);
            event.getButtonList().removeIf(b -> b instanceof GuiButtonImage && b.field_146127_k == 10);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.field_70173_aa < 20) {
            GuiToast toasts = mc.func_193033_an();
            Queue toastQueue = (Queue)ObfuscationReflectionHelper.getPrivateValue(GuiToast.class, (Object)toasts, (String)"field_191792_h");
            for (IToast toast : toastQueue) {
                RecipeToast recipeToast;
                List stacks;
                if (!(toast instanceof RecipeToast) || (stacks = (List)ObfuscationReflectionHelper.getPrivateValue(RecipeToast.class, (Object)(recipeToast = (RecipeToast)toast), (String)"field_193666_c")).size() <= 100) continue;
                toastQueue.remove(toast);
                return;
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

