/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.gfx.shaders;

import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.orecruncher.lib.Color;
import org.orecruncher.lib.gfx.shaders.ShaderException;
import org.orecruncher.lib.io.Streams;

public class ShaderProgram {
    protected final String name;
    protected int programId = -1;
    protected boolean isDrawing = false;
    protected int textureIndex = 0;

    public ShaderProgram(String name) {
        this.name = StringUtils.isEmpty((CharSequence)name) ? "UNKNOWN" : name;
    }

    protected void initialize(String vertexSrc, String fragmentSrc) throws ShaderException {
        int vertShader = 0;
        int fragShader = 0;
        vertShader = this.createShader(vertexSrc, 35633);
        fragShader = this.createShader(fragmentSrc, 35632);
        if (vertShader == 0 || fragShader == 0) {
            throw new ShaderException(this.name, "Unable to intialize shader!");
        }
        this.programId = ARBShaderObjects.glCreateProgramObjectARB();
        if (this.programId != 0) {
            ARBShaderObjects.glAttachObjectARB((int)this.programId, (int)vertShader);
            ARBShaderObjects.glAttachObjectARB((int)this.programId, (int)fragShader);
            ARBShaderObjects.glLinkProgramARB((int)this.programId);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)this.programId, (int)35714) == 0) {
                throw new ShaderException(this.name, ShaderProgram.getLogInfo(this.programId));
            }
            ARBShaderObjects.glValidateProgramARB((int)this.programId);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)this.programId, (int)35715) == 0) {
                throw new ShaderException(this.name, ShaderProgram.getLogInfo(this.programId));
            }
        }
    }

    public final String getName() {
        return this.name;
    }

    public final int getProgramId() {
        return this.programId;
    }

    public final boolean isValid() {
        return this.programId != 0;
    }

    public final void use() throws ShaderException {
        this.use(null);
    }

    public final void unUse() throws ShaderException {
        try {
            String log = ShaderProgram.getLogInfo(this.programId);
            if (!StringUtils.isEmpty((CharSequence)log)) {
                throw new ShaderException(this.name, log);
            }
        }
        finally {
            ARBShaderObjects.glUseProgramObjectARB((int)0);
        }
    }

    public final void delete() {
        if (this.isValid()) {
            ARBShaderObjects.glUseProgramObjectARB((int)0);
            ARBShaderObjects.glDeleteObjectARB((int)this.programId);
        }
    }

    public final void use(IShaderUseCallback callback) throws ShaderException {
        this.textureIndex = 0;
        ARBShaderObjects.glUseProgramObjectARB((int)this.programId);
        if (callback != null) {
            callback.call(this);
        }
    }

    protected final int getUniform(String name) throws ShaderException {
        if (!this.isValid()) {
            throw new ShaderException(this.name, "ShaderProgram is not valid!");
        }
        int id = ARBShaderObjects.glGetUniformLocationARB((int)this.programId, (CharSequence)name);
        if (id == -1) {
            throw new ShaderException(this.name, String.format("Unknown uniform '%s'", name));
        }
        return id;
    }

    public void set(String name, float ... value) throws ShaderException {
        if (value.length == 0 || value.length > 4) {
            throw new ShaderException(this.name, "Invalid number of elements");
        }
        int id = this.getUniform(name);
        if (value.length == 1) {
            ARBShaderObjects.glUniform1fARB((int)this.getUniform(name), (float)value[0]);
        } else {
            FloatBuffer buff = BufferUtils.createFloatBuffer((int)value.length);
            for (int i = 0; i < value.length; ++i) {
                buff.put(value[i]);
            }
            buff.flip();
            switch (value.length) {
                case 1: {
                    ARBShaderObjects.glUniform1ARB((int)id, (FloatBuffer)buff);
                    break;
                }
                case 2: {
                    ARBShaderObjects.glUniform2ARB((int)id, (FloatBuffer)buff);
                    break;
                }
                case 3: {
                    ARBShaderObjects.glUniform3ARB((int)id, (FloatBuffer)buff);
                    break;
                }
                case 4: {
                    ARBShaderObjects.glUniform4ARB((int)id, (FloatBuffer)buff);
                }
            }
        }
    }

    public void setMatrix4(String name, FloatBuffer matrix) throws ShaderException {
        ARBShaderObjects.glUniformMatrix4ARB((int)this.getUniform(name), (boolean)false, (FloatBuffer)matrix);
    }

    public void set(String name, Color color) throws ShaderException {
        this.set(name, color, 1.0f);
    }

    public void set(String name, Color color, float alpha) throws ShaderException {
        this.set(name, color.red, color.green, color.blue, alpha);
    }

    public void set(String name, Vec3d vector) throws ShaderException {
        this.set(name, (float)vector.field_72450_a, (float)vector.field_72448_b, (float)vector.field_72449_c);
    }

    public void set(String name, Vec3i vector) throws ShaderException {
        this.set(name, vector.func_177958_n(), vector.func_177956_o(), vector.func_177952_p());
    }

    public void set(String name, Vec2f vector) throws ShaderException {
        this.set(name, vector.field_189982_i, vector.field_189983_j);
    }

    public void set(String name, int value) throws ShaderException {
        int id = this.getUniform(name);
        ARBShaderObjects.glUniform1iARB((int)id, (int)value);
    }

    public void set(String name, ResourceLocation texture) throws ShaderException {
        int textureId = this.textureIndex++;
        GlStateManager.func_179138_g((int)(OpenGlHelper.field_77478_a + textureId));
        GlStateManager.func_179098_w();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }

    protected void initialize(ResourceLocation vertexResource, ResourceLocation fragmentResource) throws Exception {
        String vertex = Streams.readResourceAsString(vertexResource);
        String fragment = Streams.readResourceAsString(fragmentResource);
        this.initialize(vertex, fragment);
    }

    public static ShaderProgram createProgram(String name, ResourceLocation vertex, ResourceLocation fragment) throws Exception {
        ShaderProgram prog = new ShaderProgram(name);
        prog.initialize(vertex, fragment);
        return prog;
    }

    private int createShader(String src, int shaderType) throws ShaderException {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)src);
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new ShaderException(this.name, ShaderProgram.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception exc) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw exc;
        }
    }

    private static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    public static interface IShaderUseCallback {
        public void call(ShaderProgram var1) throws ShaderException;
    }
}

