/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.minecraft.defaults;

import java.util.Map;
import java.util.TreeMap;

public enum DefaultMaterial {
    AIR(0, false),
    STONE(1),
    GRASS(2),
    DIRT(3),
    COBBLESTONE(4),
    WOOD(5),
    SAPLING(6, false),
    BEDROCK(7),
    WATER(8, false),
    STATIONARY_WATER(9, false),
    LAVA(10, false),
    STATIONARY_LAVA(11, false),
    SAND(12),
    GRAVEL(13),
    GOLD_ORE(14),
    IRON_ORE(15),
    COAL_ORE(16),
    LOG(17),
    LEAVES(18, false),
    SPONGE(19),
    GLASS(20),
    LAPIS_ORE(21),
    LAPIS_BLOCK(22),
    DISPENSER(23),
    SANDSTONE(24),
    NOTE_BLOCK(25),
    BED_BLOCK(26, false),
    POWERED_RAIL(27, false),
    DETECTOR_RAIL(28, false),
    PISTON_STICKY_BASE(29, false),
    WEB(30, false),
    LONG_GRASS(31, false),
    DEAD_BUSH(32, false),
    PISTON_BASE(33),
    PISTON_EXTENSION(34, false),
    WOOL(35),
    PISTON_MOVING_PIECE(36, false),
    YELLOW_FLOWER(37, false),
    RED_ROSE(38, false),
    BROWN_MUSHROOM(39, false),
    RED_MUSHROOM(40, false),
    GOLD_BLOCK(41),
    IRON_BLOCK(42),
    DOUBLE_STEP(43),
    STEP(44, false),
    BRICK(45),
    TNT(46),
    BOOKSHELF(47),
    MOSSY_COBBLESTONE(48),
    OBSIDIAN(49),
    TORCH(50, false),
    FIRE(51, false),
    MOB_SPAWNER(52),
    WOOD_STAIRS(53),
    CHEST(54, false),
    REDSTONE_WIRE(55, false),
    DIAMOND_ORE(56),
    DIAMOND_BLOCK(57),
    WORKBENCH(58),
    CROPS(59, false),
    SOIL(60),
    FURNACE(61),
    BURNING_FURNACE(62),
    SIGN_POST(63, false),
    WOODEN_DOOR(64, false),
    LADDER(65, false),
    RAILS(66, false),
    COBBLESTONE_STAIRS(67),
    WALL_SIGN(68, false),
    LEVER(69, false),
    STONE_PLATE(70, false),
    IRON_DOOR_BLOCK(71, false),
    WOOD_PLATE(72, false),
    REDSTONE_ORE(73),
    GLOWING_REDSTONE_ORE(74),
    REDSTONE_TORCH_OFF(75, false),
    REDSTONE_TORCH_ON(76, false),
    STONE_BUTTON(77, false),
    SNOW(78, false),
    ICE(79),
    SNOW_BLOCK(80),
    CACTUS(81),
    CLAY(82),
    SUGAR_CANE_BLOCK(83),
    JUKEBOX(84, false),
    FENCE(85, false),
    PUMPKIN(86),
    NETHERRACK(87),
    SOUL_SAND(88),
    GLOWSTONE(89),
    PORTAL(90, false),
    JACK_O_LANTERN(91),
    CAKE_BLOCK(92),
    DIODE_BLOCK_OFF(93, false),
    DIODE_BLOCK_ON(94, false),
    STAINED_GLASS(95, false),
    TRAP_DOOR(96, false),
    MONSTER_EGGS(97),
    SMOOTH_BRICK(98),
    HUGE_MUSHROOM_1(99),
    HUGE_MUSHROOM_2(100),
    IRON_FENCE(101, false),
    THIN_GLASS(102, false),
    MELON_BLOCK(103),
    PUMPKIN_STEM(104, false),
    MELON_STEM(105, false),
    VINE(106, false),
    FENCE_GATE(107, false),
    BRICK_STAIRS(108),
    SMOOTH_STAIRS(109),
    MYCEL(110, true),
    WATER_LILY(111, false),
    NETHER_BRICK(112),
    NETHER_FENCE(113, false),
    NETHER_BRICK_STAIRS(114),
    NETHER_WARTS(115, false),
    ENCHANTMENT_TABLE(116, false),
    BREWING_STAND(117, false),
    CAULDRON(118),
    ENDER_PORTAL(119, false),
    ENDER_PORTAL_FRAME(120, false),
    ENDER_STONE(121),
    DRAGON_EGG(122),
    REDSTONE_LAMP_OFF(123),
    REDSTONE_LAMP_ON(124),
    WOOD_DOUBLE_STEP(125),
    WOOD_STEP(126),
    COCOA(127, false),
    SANDSTONE_STAIRS(128),
    EMERALD_ORE(129),
    ENDER_CHEST(130),
    TRIPWIRE_HOOK(131, false),
    TRIPWIRE(132, false),
    EMERALD_BLOCK(133),
    SPRUCE_WOOD_STAIRS(134),
    BIRCH_WOOD_STAIRS(135),
    JUNGLE_WOOD_STAIRS(136),
    COMMAND(137),
    BEACON(138),
    COBBLE_WALL(139, false),
    FLOWER_POT(140, false),
    CARROT(141, false),
    POTATO(142, false),
    WOOD_BUTTON(143, false),
    SKULL(144, false),
    ANVIL(145, false),
    TRAPPED_CHEST(146),
    GOLD_PLATE(147, false),
    IRON_PLATE(148, false),
    REDSTONE_COMPARATOR_OFF(149, false),
    REDSTONE_COMPARATOR_ON(150, false),
    DAYLIGHT_DETECTOR(151, false),
    REDSTONE_BLOCK(152),
    QUARTZ_ORE(153),
    HOPPER(154),
    QUARTZ_BLOCK(155),
    QUARTZ_STAIRS(156),
    ACTIVATOR_RAIL(157, false),
    DROPPER(158),
    STAINED_CLAY(159),
    STAINED_GLASS_PANE(160, false),
    LEAVES_2(161, false),
    LOG_2(162),
    ACACIA_STAIRS(163),
    DARK_OAK_STAIRS(164),
    SLIME_BLOCK(165),
    BARRIER(166),
    IRON_TRAPDOOR(167, false),
    PRISMARINE(168),
    SEA_LANTERN(169),
    HAY_BLOCK(170),
    CARPET(171, false),
    HARD_CLAY(172),
    COAL_BLOCK(173),
    PACKED_ICE(174),
    DOUBLE_PLANT(175, false),
    STANDING_BANNER(176, false),
    WALL_BANNER(177, false),
    DAYLIGHT_DETECTOR_INVERTED(178, false),
    RED_SANDSTONE(179),
    RED_SANDSTONE_STAIRS(180),
    DOUBLE_STONE_SLAB2(181),
    STONE_SLAB2(182, false),
    SPRUCE_FENCE_GATE(183, false),
    BIRCH_FENCE_GATE(184, false),
    JUNGLE_FENCE_GATE(185, false),
    DARK_OAK_FENCE_GATE(186, false),
    ACACIA_FENCE_GATE(187, false),
    SPRUCE_FENCE(188, false),
    BIRCH_FENCE(189, false),
    JUNGLE_FENCE(190, false),
    DARK_OAK_FENCE(191, false),
    ACACIA_FENCE(192, false),
    SPRUCE_DOOR(193, false),
    BIRCH_DOOR(194, false),
    JUNGLE_DOOR(195, false),
    ACACIA_DOOR(196, false),
    DARK_OAK_DOOR(197, false),
    END_ROD(198, false),
    CHORUS_PLANT(199, false),
    CHORUS_FLOWER(200, false),
    PURPUR_BLOCK(201),
    PURPUR_PILLAR(202),
    PURPUR_STAIRS(203),
    PURPUR_DOUBLE_SLAB(204),
    PURPUR_SLAB(205, false),
    END_BRICKS(206),
    BEETROOT_BLOCK(207, false),
    GRASS_PATH(208, false),
    END_GATEWAY(209, false),
    COMMAND_REPEATING(210),
    COMMAND_CHAIN(211),
    FROSTED_ICE(212),
    MAGMA(213),
    NETHER_WART_BLOCK(214),
    RED_NETHER_BRICK(215),
    BONE_BLOCK(216),
    STRUCTURE_VOID(217, false),
    OBSERVER(218),
    WHITE_SHULKER_BOX(219),
    ORANGE_SHULKER_BOX(220),
    MAGENTA_SHULKER_BOX(221),
    LIGHT_BLUE_SHULKER_BOX(222),
    YELLOW_SHULKER_BOX(223),
    LIME_SHULKER_BOX(224),
    PINK_SHULKER_BOX(225),
    GRAY_SHULKER_BOX(226),
    SILVER_SHULKER_BOX(228),
    CYAN_SHULKER_BOX(228),
    PURPLE_SHULKER_BOX(229),
    BLUE_SHULKER_BOX(230),
    BROWN_SHULKER_BOX(231),
    GREEN_SHULKER_BOX(232),
    RED_SHULKER_BOX(233),
    BLACK_SHULKER_BOX(234),
    CONCRETE(251),
    CONCRETE_POWDER(252),
    UNKNOWN_BLOCK(254),
    STRUCTURE_BLOCK(255, false);

    private static DefaultMaterial[] LookupID;
    public final int id;
    private final boolean solid;
    private static Map<String, DefaultMaterial> lookupName;

    private DefaultMaterial(int id, boolean solid) {
        this.id = id;
        this.solid = solid;
    }

    private DefaultMaterial(int id) {
        this.id = id;
        this.solid = true;
    }

    public boolean isAir() {
        return this == AIR;
    }

    public boolean isLiquid() {
        return this == WATER || this == STATIONARY_WATER || this == LAVA || this == STATIONARY_LAVA;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public boolean canSnowFallOn() {
        return this == LEAVES || this == LEAVES_2 || this.solid && this != PACKED_ICE && this != ICE;
    }

    public static DefaultMaterial getMaterial(String blockName) {
        if (blockName == null) {
            return null;
        }
        DefaultMaterial defaultMaterial = lookupName.get(blockName);
        if (defaultMaterial != null) {
            return defaultMaterial;
        }
        try {
            defaultMaterial = DefaultMaterial.getMaterial(Integer.parseInt(blockName));
        }
        catch (NumberFormatException e) {
            return null;
        }
        lookupName.put(blockName, defaultMaterial);
        return defaultMaterial;
    }

    public static boolean contains(String name) {
        return lookupName.containsKey(name);
    }

    public static DefaultMaterial getMaterial(int id) {
        if (id < 256 && id > -1 && LookupID[id] != null) {
            return LookupID[id];
        }
        return null;
    }

    public static boolean contains(int id) {
        return id < 256 && LookupID[id] != null;
    }

    static {
        LookupID = new DefaultMaterial[256];
        lookupName = new TreeMap<String, DefaultMaterial>(String.CASE_INSENSITIVE_ORDER);
        DefaultMaterial[] defaultMaterialArray = DefaultMaterial.values();
        int n = defaultMaterialArray.length;
        for (int i = 0; i < n; ++i) {
            DefaultMaterial material;
            DefaultMaterial.LookupID[material.id] = material = defaultMaterialArray[i];
            lookupName.put(material.name(), material);
        }
    }
}

