/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.helpers;

import java.lang.reflect.Field;

public final class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static <T> void setValueInFieldOfType(Object on, Class<? super T> fieldType, T newValue) {
        Field field = ReflectionHelper.getOnlyFieldDefOfType(on.getClass(), fieldType);
        try {
            field.setAccessible(true);
            field.set(on, newValue);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> T getValueInFieldOfType(Object on, Class<T> fieldType) {
        Field field = ReflectionHelper.getOnlyFieldDefOfType(on.getClass(), fieldType);
        try {
            field.setAccessible(true);
            Object fieldValue = field.get(on);
            return (T)fieldValue;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Field getOnlyFieldDefOfType(Class<?> searchClass, Class<?> fieldType) {
        Field result = null;
        for (Class<?> onClass = searchClass; onClass != null; onClass = onClass.getSuperclass()) {
            for (Field field : onClass.getDeclaredFields()) {
                if (!field.getType().equals(fieldType)) continue;
                if (result != null) {
                    throw new NoSuchFieldError("Two fields of type " + fieldType + " in " + onClass + ": " + field.getName() + " and " + result.getName());
                }
                result = field;
            }
            if (result != null) break;
        }
        if (result == null) {
            throw new NoSuchFieldError("Found no field of type " + fieldType + " in " + searchClass);
        }
        return result;
    }
}

