/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.surface;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.GeneratingChunk;
import com.pg85.otg.generator.surface.LayerChoice;
import com.pg85.otg.generator.surface.SurfaceGenerator;
import com.pg85.otg.util.materials.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;

public class SimpleSurfaceGenerator
implements SurfaceGenerator {
    @Override
    public LocalMaterialData getSurfaceBlockAtHeight(LocalWorld world, BiomeConfig biomeConfig, int xInWorld, int yInWorld, int zInWorld) {
        return biomeConfig.getSurfaceBlockReplaced(world, yInWorld);
    }

    @Override
    public LocalMaterialData getGroundBlockAtHeight(LocalWorld world, BiomeConfig biomeConfig, int xInWorld, int yInWorld, int zInWorld) {
        return biomeConfig.getGroundBlockReplaced(world, yInWorld);
    }

    @Override
    public void spawn(LocalWorld world, GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, BiomeConfig biomeConfig, int xInWorld, int zInWorld) {
        this.spawnColumn(world, null, generatingChunk, chunkBuffer, biomeConfig, xInWorld & 0xF, zInWorld & 0xF);
    }

    protected final void spawnColumn(LocalWorld world, LayerChoice layer, GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, BiomeConfig biomeConfig, int x, int z) {
        int highestBlockInColumn;
        WorldConfig worldConfig = biomeConfig.worldConfig;
        float currentTemperature = biomeConfig.biomeTemperature;
        int biomeBlocksNoise = (int)(generatingChunk.getNoise(x, z) / 3.0 + 3.0 + generatingChunk.random.nextDouble() * 0.25);
        if (worldConfig.ceilingBedrock) {
            chunkBuffer.setBlock(x, generatingChunk.heightCap - 2, z, worldConfig.getBedrockBlockReplaced(world, biomeConfig, generatingChunk.heightCap - 2));
        }
        int groundLayerDepth = -1;
        LocalMaterialData currentSurfaceBlock = null;
        boolean useWaterForSurface = false;
        boolean useIceForSurface = false;
        boolean useAirForSurface = false;
        boolean useLayerSurfaceBlockForSurface = true;
        boolean useBiomeStoneBlockForGround = false;
        boolean useLayerGroundBlockForGround = true;
        boolean useSandStoneForGround = false;
        boolean biomeGroundBlockIsSand = biomeConfig.getDefaultGroundBlock().isMaterial(DefaultMaterial.SAND);
        boolean layerGroundBlockIsSand = layer != null && layer.groundBlock.isMaterial(DefaultMaterial.SAND);
        int currentWaterLevel = generatingChunk.getWaterLevel(x, z);
        for (int y = highestBlockInColumn = chunkBuffer.getHighestBlockForColumn(x, z); y >= 0; --y) {
            if (generatingChunk.mustCreateBedrockAt(worldConfig, y)) {
                chunkBuffer.setBlock(x, y, z, worldConfig.getBedrockBlockReplaced(world, biomeConfig, y));
                continue;
            }
            LocalMaterialData blockOnCurrentPos = chunkBuffer.getBlock(x, y, z);
            if (blockOnCurrentPos.isEmptyOrAir()) {
                groundLayerDepth = -1;
                continue;
            }
            if (blockOnCurrentPos.equals(biomeConfig.getWaterBlockReplaced(world, y))) continue;
            if (groundLayerDepth == -1) {
                groundLayerDepth = biomeBlocksNoise;
                if (biomeBlocksNoise <= 0 && !worldConfig.removeSurfaceStone) {
                    useAirForSurface = true;
                    useIceForSurface = false;
                    useWaterForSurface = false;
                    useLayerSurfaceBlockForSurface = false;
                    useSandStoneForGround = false;
                    useBiomeStoneBlockForGround = true;
                    useLayerGroundBlockForGround = false;
                } else if (y >= currentWaterLevel - 4 && y <= currentWaterLevel + 1) {
                    useAirForSurface = false;
                    useIceForSurface = false;
                    useWaterForSurface = false;
                    useLayerSurfaceBlockForSurface = true;
                    useSandStoneForGround = false;
                    useBiomeStoneBlockForGround = false;
                    useLayerGroundBlockForGround = true;
                }
                if (y < currentWaterLevel && y > biomeConfig.waterLevelMin) {
                    boolean bIsAir = useAirForSurface;
                    if (!bIsAir && useLayerSurfaceBlockForSurface) {
                        bIsAir = (layer != null ? layer.getSurfaceBlockReplaced(world, biomeConfig, y) : biomeConfig.getSurfaceBlockReplaced(world, y)).isAir();
                    }
                    if (bIsAir) {
                        if (currentTemperature < 0.15f) {
                            useAirForSurface = false;
                            useIceForSurface = true;
                            useWaterForSurface = false;
                            useLayerSurfaceBlockForSurface = false;
                        } else {
                            useAirForSurface = false;
                            useIceForSurface = false;
                            useWaterForSurface = true;
                            useLayerSurfaceBlockForSurface = false;
                        }
                    }
                }
                if (y >= currentWaterLevel - 1) {
                    if (useAirForSurface) {
                        currentSurfaceBlock = MaterialHelper.AIR;
                    } else if (useIceForSurface) {
                        currentSurfaceBlock = biomeConfig.getIceBlockReplaced(world, y);
                    } else if (useWaterForSurface) {
                        currentSurfaceBlock = biomeConfig.getWaterBlockReplaced(world, y);
                    } else if (useLayerSurfaceBlockForSurface) {
                        currentSurfaceBlock = layer != null ? layer.getSurfaceBlockReplaced(world, biomeConfig, y) : biomeConfig.getSurfaceBlockReplaced(world, y);
                    }
                    chunkBuffer.setBlock(x, y, z, currentSurfaceBlock);
                    continue;
                }
                if (useBiomeStoneBlockForGround || !useLayerGroundBlockForGround) continue;
                chunkBuffer.setBlock(x, y, z, layer != null ? layer.getGroundBlockReplaced(world, biomeConfig, y) : biomeConfig.getGroundBlockReplaced(world, y));
                continue;
            }
            if (groundLayerDepth <= 0) continue;
            --groundLayerDepth;
            if (useBiomeStoneBlockForGround || !useLayerGroundBlockForGround) continue;
            if (useSandStoneForGround) {
                chunkBuffer.setBlock(x, y, z, (layerGroundBlockIsSand ? layer.groundBlock : biomeConfig.getDefaultGroundBlock()).getBlockData() == 1 ? biomeConfig.getRedSandStoneBlockReplaced(world, y) : biomeConfig.getSandStoneBlockReplaced(world, y));
            } else {
                chunkBuffer.setBlock(x, y, z, layer != null ? layer.getGroundBlockReplaced(world, biomeConfig, y) : biomeConfig.getGroundBlockReplaced(world, y));
            }
            if (groundLayerDepth != 0 || biomeBlocksNoise <= 1 || !layerGroundBlockIsSand && (layer != null || !biomeGroundBlockIsSand)) continue;
            groundLayerDepth = generatingChunk.random.nextInt(4) + Math.max(0, y - currentWaterLevel);
            useSandStoneForGround = true;
        }
    }

    @Override
    public String toString() {
        return "";
    }
}

