/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.MaterialHelper;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class OreGen
extends Resource {
    private final int maxAltitude;
    private final int maxSize;
    private final int minAltitude;
    private final MaterialSet sourceBlocks;
    byte[][] highestBlocksCache;

    public OreGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(7, args);
        this.material = this.readMaterial(args.get(0));
        this.maxSize = this.readInt(args.get(1), 1, 128);
        this.frequency = this.readInt(args.get(2), 1, 100);
        this.rarity = this.readRarity(args.get(3));
        this.minAltitude = this.readInt(args.get(4), 0, 255);
        this.maxAltitude = this.readInt(args.get(5), this.minAltitude, 255);
        this.sourceBlocks = this.readMaterials(args, 6);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        OreGen compare = (OreGen)other;
        return this.maxSize == compare.maxSize && this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude && (this.sourceBlocks == null ? this.sourceBlocks == compare.sourceBlocks : this.sourceBlocks.equals(compare.sourceBlocks));
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + super.hashCode();
        hash = 11 * hash + this.minAltitude;
        hash = 11 * hash + this.maxAltitude;
        hash = 11 * hash + this.maxSize;
        hash = 11 * hash + (this.sourceBlocks != null ? this.sourceBlocks.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return "Ore(" + this.material + "," + this.maxSize + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }

    @Override
    protected void createCache() {
        this.highestBlocksCache = new byte[32][32];
    }

    @Override
    protected void clearCache() {
        this.highestBlocksCache = null;
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z, ChunkCoordinate chunkBeingPopulated) {
        this.parseMaterials(world, this.material, this.sourceBlocks);
        if (world.getConfigs().getWorldConfig().disableOreGen && MaterialHelper.isOre(this.material)) {
            return;
        }
        int y = RandomHelper.numberInRange(rand, this.minAltitude, this.maxAltitude);
        float f = rand.nextFloat() * (float)Math.PI;
        double d0 = (float)(x + 8) + MathHelper.sin(f) * (float)this.maxSize / 8.0f;
        double d1 = (float)(x + 8) - MathHelper.sin(f) * (float)this.maxSize / 8.0f;
        double d2 = (float)(z + 8) + MathHelper.cos(f) * (float)this.maxSize / 8.0f;
        double d3 = (float)(z + 8) - MathHelper.cos(f) * (float)this.maxSize / 8.0f;
        double d4 = y + rand.nextInt(3) - 2;
        double d5 = y + rand.nextInt(3) - 2;
        int areaBeingPoulatedSize = 32;
        for (int i = 0; i < this.maxSize; ++i) {
            float iFactor = (float)i / (float)this.maxSize;
            double d6 = d0 + (d1 - d0) * (double)iFactor;
            double d7 = d4 + (d5 - d4) * (double)iFactor;
            double d8 = d2 + (d3 - d2) * (double)iFactor;
            double d9 = rand.nextDouble() * (double)this.maxSize / 16.0;
            double d10 = (double)(MathHelper.sin((float)Math.PI * iFactor) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.sin((float)Math.PI * iFactor) + 1.0f) * d9 + 1.0;
            int j = MathHelper.floor(d6 - d10 / 2.0);
            int k = MathHelper.floor(d7 - d11 / 2.0);
            int l = MathHelper.floor(d8 - d10 / 2.0);
            int i1 = MathHelper.floor(d6 + d10 / 2.0);
            int j1 = MathHelper.floor(d7 + d11 / 2.0);
            int k1 = MathHelper.floor(d8 + d10 / 2.0);
            if (j < chunkBeingPopulated.getBlockX() || j > chunkBeingPopulated.getBlockX() + areaBeingPoulatedSize - 1 || i1 < chunkBeingPopulated.getBlockX() || i1 > chunkBeingPopulated.getBlockX() + areaBeingPoulatedSize - 1 || l < chunkBeingPopulated.getBlockZ() || l > chunkBeingPopulated.getBlockZ() + areaBeingPoulatedSize - 1 || k1 < chunkBeingPopulated.getBlockZ() || k1 > chunkBeingPopulated.getBlockZ() + areaBeingPoulatedSize - 1 || k < 0 || k > 255) continue;
            block1: for (int i3 = j; i3 <= i1; ++i3) {
                double d13 = ((double)i3 + 0.5 - d6) / (d10 / 2.0);
                if (!(d13 * d13 < 1.0)) continue;
                for (int i5 = l; i5 <= k1; ++i5) {
                    if (j1 > 63) {
                        int highestSolidBlock = this.highestBlocksCache[i3 - chunkBeingPopulated.getBlockX()][i5 - chunkBeingPopulated.getBlockZ()] & 0xFF;
                        if (highestSolidBlock == 0) {
                            highestSolidBlock = world.getHeightMapHeight(i3, i5, chunkBeingPopulated);
                            if (highestSolidBlock == -1) {
                                highestSolidBlock = 0;
                                continue block1;
                            }
                            this.highestBlocksCache[i3 - chunkBeingPopulated.getBlockX()][i5 - chunkBeingPopulated.getBlockZ()] = (byte)highestSolidBlock;
                        }
                        if (j1 > highestSolidBlock) {
                            j1 = highestSolidBlock;
                        }
                    }
                    for (int i4 = k; i4 <= j1; ++i4) {
                        LocalMaterialData material;
                        double d15;
                        double d14 = ((double)i4 + 0.5 - d7) / (d11 / 2.0);
                        if (!(d13 * d13 + d14 * d14 < 1.0) || !(d13 * d13 + d14 * d14 + (d15 = ((double)i5 + 0.5 - d8) / (d10 / 2.0)) * d15 < 1.0) || !this.sourceBlocks.contains(material = world.getMaterial(i3, i4, i5, chunkBeingPopulated))) continue;
                        world.setBlock(i3, i4, i5, this.material, null, chunkBeingPopulated, true);
                    }
                }
            }
        }
    }
}

