/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.RandomHelper;
import java.util.List;
import java.util.Random;

public class DungeonGen
extends Resource {
    private final int maxAltitude;
    private final int minAltitude;

    public DungeonGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(4, args);
        this.frequency = this.readInt(args.get(0), 1, 100);
        this.rarity = this.readRarity(args.get(1));
        this.minAltitude = this.readInt(args.get(2), 0, 255);
        this.maxAltitude = this.readInt(args.get(3), this.minAltitude, 255);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DungeonGen compare = (DungeonGen)other;
        return this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude;
    }

    @Override
    public int getPriority() {
        return -20;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + super.hashCode();
        hash = 61 * hash + this.minAltitude;
        hash = 61 * hash + this.maxAltitude;
        return hash;
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        return this.getClass() == other.getClass();
    }

    @Override
    public String toString() {
        return "Dungeon(" + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + ")";
    }

    @Override
    public void spawn(LocalWorld world, Random random, boolean villageInChunk, int x, int z, ChunkCoordinate chunkBeingPopulated) {
        int y = RandomHelper.numberInRange(random, this.minAltitude, this.maxAltitude);
        world.placeDungeon(random, x, y, z);
    }
}

