/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class CactusGen
extends Resource {
    private int minAltitude;
    private int maxAltitude;
    private MaterialSet sourceBlocks;

    public CactusGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(6, args);
        this.material = this.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
        this.minAltitude = this.readInt(args.get(3), 0, 255);
        this.maxAltitude = this.readInt(args.get(4), this.minAltitude, 255);
        this.sourceBlocks = this.readMaterials(args, 5);
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z, ChunkCoordinate chunkBeingPopulated) {
        int y = RandomHelper.numberInRange(rand, this.minAltitude, this.maxAltitude);
        this.parseMaterials(world, this.material, this.sourceBlocks);
        for (int i = 0; i < 10; ++i) {
            int cactusZ;
            int cactusBaseY;
            int cactusX = x + rand.nextInt(8) - rand.nextInt(8);
            LocalMaterialData worldMaterial = world.getMaterial(cactusX, cactusBaseY = y + rand.nextInt(4) - rand.nextInt(4), cactusZ = z + rand.nextInt(8) - rand.nextInt(8), chunkBeingPopulated);
            if (worldMaterial == null || !worldMaterial.isAir() || (worldMaterial = world.getMaterial(cactusX, cactusBaseY - 1, cactusZ, chunkBeingPopulated)) == null || !this.sourceBlocks.contains(worldMaterial) || (worldMaterial = world.getMaterial(cactusX - 1, cactusBaseY, cactusZ, chunkBeingPopulated)) == null || !worldMaterial.isAir() || (worldMaterial = world.getMaterial(cactusX + 1, cactusBaseY, cactusZ, chunkBeingPopulated)) == null || !worldMaterial.isAir() || (worldMaterial = world.getMaterial(cactusX, cactusBaseY, cactusZ - 1, chunkBeingPopulated)) == null || !worldMaterial.isAir() || (worldMaterial = world.getMaterial(cactusX, cactusBaseY, cactusZ + 1, chunkBeingPopulated)) == null || !worldMaterial.isAir()) continue;
            int cactusHeight = 1 + rand.nextInt(rand.nextInt(3) + 1);
            for (int dY = 0; dY < cactusHeight; ++dY) {
                world.setBlock(cactusX, cactusBaseY + dY, cactusZ, this.material, null, chunkBeingPopulated, false);
            }
        }
    }

    @Override
    public String toString() {
        return "Cactus(" + this.material + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + super.hashCode();
        hash = 79 * hash + this.minAltitude;
        hash = 79 * hash + this.maxAltitude;
        hash = 79 * hash + (this.sourceBlocks != null ? this.sourceBlocks.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        CactusGen compare = (CactusGen)other;
        return this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude && (this.sourceBlocks == null ? this.sourceBlocks == compare.sourceBlocks : this.sourceBlocks.equals(compare.sourceBlocks));
    }

    @Override
    public int getPriority() {
        return -35;
    }
}

