/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.List;
import java.util.Random;

public class AboveWaterGen
extends Resource {
    public AboveWaterGen(BiomeConfig config, List<String> args) throws InvalidConfigException {
        super(config);
        this.assureSize(3, args);
        this.material = this.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z, ChunkCoordinate chunkBeingPopulated) {
        int y = world.getBlockAboveLiquidHeight(x, z, chunkBeingPopulated);
        if (y == -1) {
            return;
        }
        this.parseMaterials(world, this.material, null);
        for (int i = 0; i < 10; ++i) {
            LocalMaterialData worldMaterialBeneath;
            int m;
            int k;
            int j = x + rand.nextInt(8) - rand.nextInt(8);
            LocalMaterialData worldMaterial = world.getMaterial(j, k = y + rand.nextInt(4) - rand.nextInt(4), m = z + rand.nextInt(8) - rand.nextInt(8), chunkBeingPopulated);
            if (worldMaterial == null || !worldMaterial.isAir() || (worldMaterialBeneath = world.getMaterial(j, k - 1, m, chunkBeingPopulated)) != null && !worldMaterialBeneath.isLiquid()) continue;
            world.setBlock(j, k, m, this.material, null, chunkBeingPopulated, false);
        }
    }

    @Override
    public String toString() {
        return "AboveWaterRes(" + this.material + "," + this.frequency + "," + this.rarity + ")";
    }

    @Override
    public int getPriority() {
        return -11;
    }
}

