/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome.layers;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.generator.biome.ArraysCache;
import com.pg85.otg.generator.biome.layers.Layer;

public class LayerBiomeBeforeGroups
extends Layer {
    private LocalBiome[] biomes;
    private LocalBiome[] ice_biomes;

    LayerBiomeBeforeGroups(long seed, int defaultOceanId, Layer childLayer, LocalBiome[] biomes, LocalBiome[] ice_biomes) {
        super(seed, defaultOceanId);
        this.child = childLayer;
        this.biomes = biomes;
        this.ice_biomes = ice_biomes;
    }

    @Override
    public int[] getInts(LocalWorld world, ArraysCache cache, int x, int z, int xSize, int zSize) {
        int[] childInts = this.child.getInts(world, cache, x, z, xSize, zSize);
        int[] thisInts = cache.getArray(xSize * zSize);
        for (int i = 0; i < zSize; ++i) {
            for (int j = 0; j < xSize; ++j) {
                this.initChunkSeed(j + x, i + z);
                int currentPiece = childInts[j + i * xSize];
                if ((currentPiece & 0x800000) == 0 || (currentPiece & 0x7FF) == this.defaultOceanId) {
                    LocalBiome biome;
                    if (this.biomes.length > 0 && (currentPiece & 0x2000) == 0) {
                        biome = this.biomes[this.nextInt(this.biomes.length)];
                        if (biome != null) {
                            currentPiece |= biome.getIds().getOTGBiomeId() | 0x800000;
                        }
                    } else if (this.ice_biomes.length > 0 && (currentPiece & 0x2000) != 0 && (biome = this.ice_biomes[this.nextInt(this.ice_biomes.length)]) != null) {
                        currentPiece |= biome.getIds().getOTGBiomeId() | 0x800000;
                    }
                }
                thisInts[j + i * xSize] = currentPiece;
            }
        }
        return thisInts;
    }
}

