/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.GeneratingChunk;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.generator.biome.OutputType;
import com.pg85.otg.generator.noise.NoiseGeneratorPerlinMesaBlocks;
import com.pg85.otg.generator.noise.NoiseGeneratorPerlinOctaves;
import com.pg85.otg.generator.terrain.CavesGen;
import com.pg85.otg.generator.terrain.RavinesGen;
import com.pg85.otg.generator.terrain.TerrainGenBase;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.materials.MaterialHelper;
import java.util.Random;

public class ChunkProviderOTG {
    private static final int NOISE_MAX_X = 5;
    private static final int NOISE_MAX_Z = 5;
    private final Random random;
    private final NoiseGeneratorPerlinOctaves vol1NoiseGen;
    private final NoiseGeneratorPerlinOctaves vol2NoiseGen;
    private final NoiseGeneratorPerlinOctaves volNoiseGen;
    private final NoiseGeneratorPerlinMesaBlocks biomeBlocksNoiseGen;
    private final NoiseGeneratorPerlinOctaves oldTerrainGeneratorNoiseGen;
    private final NoiseGeneratorPerlinOctaves noiseHeightNoiseGen;
    private double[] biomeBlocksNoise = new double[256];
    private double[] volNoise;
    private double[] vol1Noise;
    private double[] vol2Noise;
    private double[] oldTerrainGeneratorNoise;
    private double[] noiseHeightNoise;
    private float[] nearBiomeWeightArray;
    private double riverVol;
    private double riverHeight;
    private boolean riverFound = false;
    private final LocalWorld localWorld;
    private double volatilityFactor;
    private double heightFactor;
    private final ConfigProvider configProvider;
    private final TerrainGenBase caveGen;
    private final TerrainGenBase canyonGen;
    private final byte[] waterLevelRaw = new byte[25];
    private final int heightScale;
    private final int heightCap;
    private final int maxSmoothDiameter;
    private final int maxSmoothRadius;
    private BiomeConfig[] biomes = new BiomeConfig[2048];
    private int lastX = Integer.MAX_VALUE;
    private int lastZ = Integer.MAX_VALUE;
    private double lastNoise = 0.0;

    public ChunkProviderOTG(ConfigProvider configs, LocalWorld world) {
        this.configProvider = configs;
        this.localWorld = world;
        this.heightCap = world.getHeightCap();
        this.heightScale = world.getHeightScale();
        this.random = new Random(world.getSeed());
        this.vol1NoiseGen = new NoiseGeneratorPerlinOctaves(this.random, 16);
        this.vol2NoiseGen = new NoiseGeneratorPerlinOctaves(this.random, 16);
        this.volNoiseGen = new NoiseGeneratorPerlinOctaves(this.random, 8);
        this.biomeBlocksNoiseGen = new NoiseGeneratorPerlinMesaBlocks(this.random, 4);
        this.oldTerrainGeneratorNoiseGen = new NoiseGeneratorPerlinOctaves(this.random, 10);
        this.noiseHeightNoiseGen = new NoiseGeneratorPerlinOctaves(this.random, 16);
        this.caveGen = new CavesGen(configs.getWorldConfig(), this.localWorld);
        this.canyonGen = new RavinesGen(configs.getWorldConfig(), this.localWorld);
        WorldConfig worldConfig = configs.getWorldConfig();
        this.maxSmoothDiameter = worldConfig.maxSmoothRadius * 2 + 1;
        this.maxSmoothRadius = worldConfig.maxSmoothRadius;
        this.nearBiomeWeightArray = new float[this.maxSmoothDiameter * this.maxSmoothDiameter];
        for (int x = -this.maxSmoothRadius; x <= this.maxSmoothRadius; ++x) {
            for (int z = -this.maxSmoothRadius; z <= this.maxSmoothRadius; ++z) {
                float f1;
                this.nearBiomeWeightArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * this.maxSmoothDiameter] = f1 = 10.0f / MathHelper.sqrt((float)(x * x + z * z) + 0.2f);
            }
        }
    }

    public void generate(ChunkBuffer chunkBuffer) {
        ChunkCoordinate chunkCoord = chunkBuffer.getChunkCoordinate();
        int x = chunkCoord.getChunkX();
        int z = chunkCoord.getChunkZ();
        this.random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        boolean dry = this.generateTerrainA(x, z, chunkBuffer);
        if (!this.localWorld.generateModdedCaveGen(x, z, chunkBuffer)) {
            this.caveGen.generate(chunkBuffer);
        }
        this.canyonGen.generate(chunkBuffer);
        WorldConfig worldConfig = this.configProvider.getWorldConfig();
        if (worldConfig.modeTerrain == WorldConfig.TerrainMode.Normal) {
            this.localWorld.prepareDefaultStructures(x, z, dry);
        }
    }

    private void generateTerrain(ChunkBuffer chunkBuffer) {
    }

    private boolean generateTerrainA(int x, int z, ChunkBuffer chunkBuffer) {
        int[] biomeArray = null;
        byte[] waterLevel = new byte[256];
        ChunkCoordinate chunkCoord = chunkBuffer.getChunkCoordinate();
        int chunkX = chunkCoord.getChunkX();
        int chunkZ = chunkCoord.getChunkZ();
        int maxYSections = this.heightCap / 8 + 1;
        int usedYSections = this.heightScale / 8 + 1;
        WorldConfig worldConfig = this.configProvider.getWorldConfig();
        BiomeGenerator biomeGenerator = this.localWorld.getBiomeGenerator();
        int[] riverArray = null;
        if (worldConfig.improvedRivers) {
            riverArray = biomeGenerator.getBiomesUnZoomed(riverArray, chunkX * 4 - this.maxSmoothRadius, chunkZ * 4 - this.maxSmoothRadius, 5 + this.maxSmoothDiameter, 5 + this.maxSmoothDiameter, OutputType.ONLY_RIVERS);
        }
        biomeArray = biomeGenerator.canGenerateUnZoomed() ? biomeGenerator.getBiomesUnZoomed(biomeArray, chunkX * 4 - this.maxSmoothRadius, chunkZ * 4 - this.maxSmoothRadius, 5 + this.maxSmoothDiameter, 5 + this.maxSmoothDiameter, OutputType.DEFAULT_FOR_WORLD) : biomeGenerator.getBiomes(biomeArray, chunkX * 16, chunkZ * 16, 16, 16, OutputType.DEFAULT_FOR_WORLD);
        double[] rawTerrain = this.generateTerrainNoise(chunkX * 4, chunkZ * 4, maxYSections, usedYSections, biomeArray, riverArray);
        if (biomeGenerator.canGenerateUnZoomed()) {
            biomeArray = biomeGenerator.getBiomes(biomeArray, chunkX * 16, chunkZ * 16, 16, 16, OutputType.DEFAULT_FOR_WORLD);
        }
        for (int noiseX = 0; noiseX < 4; ++noiseX) {
            for (int noiseZ = 0; noiseZ < 4; ++noiseZ) {
                double z1;
                double z0;
                double xLerp;
                double waterLevel_x0z0 = this.waterLevelRaw[noiseX * 5 + noiseZ] & 0xFF;
                double waterLevel_x0z1 = this.waterLevelRaw[noiseX * 5 + noiseZ + 1] & 0xFF;
                double waterLevel_x1z0 = this.waterLevelRaw[(noiseX + 1) * 5 + noiseZ] & 0xFF;
                double waterLevel_x1z1 = this.waterLevelRaw[(noiseX + 1) * 5 + noiseZ + 1] & 0xFF;
                for (int pieceX = 0; pieceX < 4; ++pieceX) {
                    xLerp = (double)pieceX / 4.0;
                    z0 = ChunkProviderOTG.lerp(xLerp, waterLevel_x0z0, waterLevel_x1z0);
                    z1 = ChunkProviderOTG.lerp(xLerp, waterLevel_x0z1, waterLevel_x1z1);
                    for (int pieceZ = 0; pieceZ < 4; ++pieceZ) {
                        double waterLevelForArray = ChunkProviderOTG.lerp((double)pieceZ / 8.0, z0, z1);
                        waterLevel[(noiseZ * 4 + pieceZ) * 16 + (pieceX + noiseX * 4)] = (byte)waterLevelForArray;
                    }
                }
                for (int noiseY = 0; noiseY < this.heightCap / 8; ++noiseY) {
                    double x0z0y0 = rawTerrain[(noiseX * 5 + noiseZ) * maxYSections + noiseY];
                    double x0z1y0 = rawTerrain[(noiseX * 5 + noiseZ + 1) * maxYSections + noiseY];
                    double x1z0y0 = rawTerrain[((noiseX + 1) * 5 + noiseZ) * maxYSections + noiseY];
                    double x1z1y0 = rawTerrain[((noiseX + 1) * 5 + noiseZ + 1) * maxYSections + noiseY];
                    double x0z0y1 = rawTerrain[(noiseX * 5 + noiseZ) * maxYSections + noiseY + 1];
                    double x0z1y1 = rawTerrain[(noiseX * 5 + noiseZ + 1) * maxYSections + noiseY + 1];
                    double x1z0y1 = rawTerrain[((noiseX + 1) * 5 + noiseZ) * maxYSections + noiseY + 1];
                    double x1z1y1 = rawTerrain[((noiseX + 1) * 5 + noiseZ + 1) * maxYSections + noiseY + 1];
                    for (int pieceY = 0; pieceY < 8; ++pieceY) {
                        double yLerp = (double)pieceY / 8.0;
                        double x0z0 = ChunkProviderOTG.lerp(yLerp, x0z0y0, x0z0y1);
                        double x1z0 = ChunkProviderOTG.lerp(yLerp, x1z0y0, x1z0y1);
                        double x0z1 = ChunkProviderOTG.lerp(yLerp, x0z1y0, x0z1y1);
                        double x1z1 = ChunkProviderOTG.lerp(yLerp, x1z1y0, x1z1y1);
                        for (int pieceX = 0; pieceX < 4; ++pieceX) {
                            xLerp = (double)pieceX / 4.0;
                            z0 = ChunkProviderOTG.lerp(xLerp, x0z0, x1z0);
                            z1 = ChunkProviderOTG.lerp(xLerp, x0z1, x1z1);
                            for (int pieceZ = 0; pieceZ < 4; ++pieceZ) {
                                BiomeConfig biomeConfig = this.toBiomeConfig(biomeArray[(noiseZ * 4 + pieceZ) * 16 + (pieceX + noiseX * 4)]);
                                int waterLevelMax = waterLevel[(noiseZ * 4 + pieceZ) * 16 + (pieceX + noiseX * 4)] & 0xFF;
                                double zLerp = (double)pieceZ / 4.0;
                                double density = ChunkProviderOTG.lerp(zLerp, z0, z1);
                                LocalMaterialData block = MaterialHelper.AIR;
                                int realY = noiseY * 8 + pieceY;
                                if (realY < waterLevelMax && realY > biomeConfig.waterLevelMin) {
                                    block = biomeConfig.getWaterBlockReplaced(this.localWorld, realY);
                                    chunkBuffer.setHighestBlockForColumn(pieceX + noiseX * 4, noiseZ * 4 + pieceZ, realY);
                                }
                                if (density > 0.0) {
                                    block = biomeConfig.getStoneBlockReplaced(this.localWorld, realY);
                                    chunkBuffer.setHighestBlockForColumn(pieceX + noiseX * 4, noiseZ * 4 + pieceZ, realY);
                                }
                                chunkBuffer.setBlock(pieceX + noiseX * 4, realY, noiseZ * 4 + pieceZ, block);
                            }
                        }
                    }
                }
            }
        }
        boolean dry = false;
        if (OTG.fireReplaceBiomeBlocksEvent(x, z, chunkBuffer, this.localWorld)) {
            dry = this.addBiomeBlocksAndCheckWater(chunkBuffer, biomeArray, waterLevel);
        }
        return dry;
    }

    public double getBiomeBlocksNoiseValue(int blockX, int blockZ) {
        double noise = this.lastNoise;
        if (this.lastX != blockX || this.lastZ != blockZ) {
            double d1 = 0.03125;
            noise = this.biomeBlocksNoiseGen.getRegion(new double[1], blockX, blockZ, 1, 1, 0.0625, 0.0625, 1.0)[0];
            this.lastX = blockX;
            this.lastZ = blockZ;
            this.lastNoise = noise;
        }
        return noise;
    }

    private boolean addBiomeBlocksAndCheckWater(ChunkBuffer chunkBuffer, int[] biomeArray, byte[] waterLevel) {
        ChunkCoordinate chunkCoord = chunkBuffer.getChunkCoordinate();
        int dryBlocksOnSurface = 256;
        double d1 = 0.03125;
        this.biomeBlocksNoise = this.biomeBlocksNoiseGen.getRegion(this.biomeBlocksNoise, chunkCoord.getBlockX(), chunkCoord.getBlockZ(), 16, 16, 0.0625, 0.0625, 1.0);
        GeneratingChunk generatingChunk = new GeneratingChunk(this.random, waterLevel, this.biomeBlocksNoise, this.heightCap);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BiomeConfig biomeConfig = this.toBiomeConfig(biomeArray[x + z * 16]);
                biomeConfig.surfaceAndGroundControl.spawn(this.localWorld, generatingChunk, chunkBuffer, biomeConfig, chunkCoord.getBlockX() + x, chunkCoord.getBlockZ() + z);
                if (!chunkBuffer.getBlock(x, biomeConfig.waterLevelMax, z).isLiquid()) continue;
                --dryBlocksOnSurface;
            }
        }
        return dryBlocksOnSurface > 250;
    }

    private double[] generateTerrainNoise(int xOffset, int zOffset, int maxYSections, int usedYSections, int[] biomeArray, int[] riverArray) {
        double[] rawTerrain = new double[5 * maxYSections * 5];
        WorldConfig worldConfig = this.configProvider.getWorldConfig();
        double xzScale = 684.412 * worldConfig.getFractureHorizontal();
        double yScale = 684.412 * worldConfig.getFractureVertical();
        if (worldConfig.oldTerrainGenerator) {
            this.oldTerrainGeneratorNoise = this.oldTerrainGeneratorNoiseGen.Noise2D(this.oldTerrainGeneratorNoise, xOffset, zOffset, 5, 5, 1.121, 1.121);
        }
        this.noiseHeightNoise = this.noiseHeightNoiseGen.Noise2D(this.noiseHeightNoise, xOffset, zOffset, 5, 5, 200.0, 200.0);
        this.volNoise = this.volNoiseGen.Noise3D(this.volNoise, xOffset, 0, zOffset, 5, maxYSections, 5, xzScale / 80.0, yScale / 160.0, xzScale / 80.0);
        this.vol1Noise = this.vol1NoiseGen.Noise3D(this.vol1Noise, xOffset, 0, zOffset, 5, maxYSections, 5, xzScale, yScale, xzScale);
        this.vol2Noise = this.vol2NoiseGen.Noise3D(this.vol2Noise, xOffset, 0, zOffset, 5, maxYSections, 5, xzScale, yScale, xzScale);
        int i3D = 0;
        int i2D = 0;
        for (int x = 0; x < 5; ++x) {
            for (int z = 0; z < 5; ++z) {
                double noiseHeight;
                int biomeId = biomeArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)];
                BiomeConfig biomeConfig = this.toBiomeConfig(biomeId);
                double volatility1 = biomeConfig.volatility1;
                double volatility2 = biomeConfig.volatility2;
                double volatilityWeight1 = biomeConfig.volatilityWeight1;
                double volatilityWeight2 = biomeConfig.volatilityWeight2;
                double maxAverageDepth = biomeConfig.maxAverageDepth;
                double maxAverageHeight = biomeConfig.maxAverageHeight;
                if (worldConfig.improvedSmoothing) {
                    double[] data = this.smoothRemainingData(x, z, biomeArray);
                    volatility1 = data[0];
                    volatility2 = data[1];
                    volatilityWeight1 = data[2];
                    volatilityWeight2 = data[3];
                    maxAverageDepth = data[4];
                    maxAverageHeight = data[5];
                }
                if ((noiseHeight = this.noiseHeightNoise[i2D] / 8000.0) < 0.0) {
                    noiseHeight = -noiseHeight * 0.3;
                }
                if ((noiseHeight = noiseHeight * 3.0 - 2.0) < 0.0) {
                    if ((noiseHeight /= 2.0) < -1.0) {
                        noiseHeight = -1.0;
                    }
                    noiseHeight -= maxAverageDepth;
                    noiseHeight /= 1.4;
                    noiseHeight /= 2.0;
                } else {
                    if (noiseHeight > 1.0) {
                        noiseHeight = 1.0;
                    }
                    noiseHeight += maxAverageHeight;
                    noiseHeight /= 8.0;
                }
                if (!worldConfig.oldTerrainGenerator) {
                    if (worldConfig.improvedRivers) {
                        this.biomeFactorWithRivers(x, z, usedYSections, noiseHeight, biomeArray, riverArray);
                    } else {
                        this.biomeFactor(x, z, usedYSections, noiseHeight, biomeArray);
                    }
                } else {
                    this.oldBiomeFactor(x, z, i2D, usedYSections, noiseHeight, biomeArray);
                }
                ++i2D;
                double[] CHC = new double[biomeConfig.heightMatrix.length];
                double[] riverCHC = new double[biomeConfig.riverHeightMatrix.length];
                if (worldConfig.customHeightControlSmoothing) {
                    this.smoothCHC(CHC, riverCHC, x, z, maxYSections, biomeArray);
                } else {
                    CHC = biomeConfig.heightMatrix;
                    riverCHC = biomeConfig.riverHeightMatrix;
                }
                for (int y = 0; y < maxYSections; ++y) {
                    double columnHeight = this.riverFound ? (this.riverHeight - (double)y) * 12.0 * 128.0 / (double)this.heightCap / this.riverVol : (this.heightFactor - (double)y) * 12.0 * 128.0 / (double)this.heightCap / this.volatilityFactor;
                    if (columnHeight > 0.0) {
                        columnHeight *= 4.0;
                    }
                    double vol1 = this.vol1Noise[i3D] / 512.0 * volatility1;
                    double vol2 = this.vol2Noise[i3D] / 512.0 * volatility2;
                    double interpolationNoise = (this.volNoise[i3D] / 10.0 + 1.0) / 2.0;
                    double output = interpolationNoise < volatilityWeight1 ? vol1 : (interpolationNoise > volatilityWeight2 ? vol2 : ChunkProviderOTG.lerp(interpolationNoise, vol1, vol2));
                    if (!biomeConfig.disableNotchHeightControl) {
                        output += columnHeight;
                        if (y > maxYSections - 4) {
                            double topFalloff = (float)(y - (maxYSections - 4)) / 3.0f;
                            output = output * (1.0 - topFalloff) + -10.0 * topFalloff;
                        }
                    }
                    output = this.riverFound ? (output += riverCHC[Math.min(biomeConfig.riverHeightMatrix.length - 1, y)]) : (output += CHC[Math.min(biomeConfig.heightMatrix.length - 1, y)]);
                    rawTerrain[i3D] = output;
                    ++i3D;
                }
            }
        }
        return rawTerrain;
    }

    private void oldBiomeFactor(int x, int z, int i2D, int ySections, double noiseHeight, int[] biomeArray) {
        BiomeConfig biomeConfig = this.toBiomeConfig(biomeArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
        this.volatilityFactor = 1.0 - (double)(Math.min(1.0f, biomeConfig.biomeTemperature) * biomeConfig.biomeWetness);
        this.volatilityFactor *= this.volatilityFactor;
        this.volatilityFactor = 1.0 - this.volatilityFactor * this.volatilityFactor;
        this.volatilityFactor = (this.volNoise[i2D] + 256.0) / 512.0 * this.volatilityFactor;
        if (this.volatilityFactor > 1.0) {
            this.volatilityFactor = 1.0;
        }
        if (this.volatilityFactor < 0.0 || noiseHeight < 0.0) {
            this.volatilityFactor = 0.0;
        }
        this.volatilityFactor += 0.5;
        this.heightFactor = (double)ySections * (2.0 + noiseHeight) / 4.0;
    }

    private void biomeFactor(int x, int z, int ySections, double noiseHeight, int[] biomeArray) {
        float volatilitySum = 0.0f;
        double heightSum = 0.0;
        float biomeWeightSum = 0.0f;
        BiomeConfig centerBiomeConfig = this.toBiomeConfig(biomeArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
        int lookRadius = centerBiomeConfig.smoothRadius;
        for (int nextX = -lookRadius; nextX <= lookRadius; ++nextX) {
            for (int nextZ = -lookRadius; nextZ <= lookRadius; ++nextZ) {
                BiomeConfig nextBiomeConfig = this.toBiomeConfig(biomeArray[x + nextX + this.maxSmoothRadius + (z + nextZ + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
                float nextBiomeHeight = nextBiomeConfig.biomeHeight;
                float biomeWeight = this.nearBiomeWeightArray[nextX + this.maxSmoothRadius + (nextZ + this.maxSmoothRadius) * this.maxSmoothDiameter] / (nextBiomeHeight + 2.0f);
                biomeWeight = Math.abs(biomeWeight);
                volatilitySum += nextBiomeConfig.biomeVolatility * biomeWeight;
                heightSum += (double)(nextBiomeHeight * biomeWeight);
                biomeWeightSum += biomeWeight;
            }
        }
        volatilitySum /= biomeWeightSum;
        heightSum /= (double)biomeWeightSum;
        this.waterLevelRaw[x * 5 + z] = (byte)centerBiomeConfig.waterLevelMax;
        volatilitySum = volatilitySum * 0.9f + 0.1f;
        heightSum = (heightSum * 4.0 - 1.0) / 8.0;
        this.volatilityFactor = volatilitySum;
        this.heightFactor = (double)ySections * (2.0 + heightSum + noiseHeight * 0.2) / 4.0;
    }

    private void biomeFactorWithRivers(int x, int z, int ySections, double noiseHeight, int[] biomeArray, int[] riverArray) {
        float volatilitySum = 0.0f;
        float heightSum = 0.0f;
        float WeightSum = 0.0f;
        float riverVolatilitySum = 0.0f;
        float riverHeightSum = 0.0f;
        float riverWeightSum = 0.0f;
        BiomeConfig biomeConfig = this.toBiomeConfig(biomeArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
        int lookRadius = biomeConfig.smoothRadius;
        this.riverFound = riverArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)] == 1;
        float riverCenterHeight = this.riverFound ? biomeConfig.riverHeight : biomeConfig.biomeHeight;
        for (int nextX = -lookRadius; nextX <= lookRadius; ++nextX) {
            for (int nextZ = -lookRadius; nextZ <= lookRadius; ++nextZ) {
                BiomeConfig nextBiomeConfig = this.toBiomeConfig(biomeArray[x + nextX + this.maxSmoothRadius + (z + nextZ + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
                float nextBiomeHeight = nextBiomeConfig.biomeHeight;
                float biomeWeight = this.nearBiomeWeightArray[nextX + this.maxSmoothRadius + (nextZ + this.maxSmoothRadius) * this.maxSmoothDiameter] / (nextBiomeHeight + 2.0f);
                biomeWeight = Math.abs(biomeWeight);
                volatilitySum += nextBiomeConfig.biomeVolatility * biomeWeight;
                heightSum += nextBiomeHeight * biomeWeight;
                WeightSum += biomeWeight;
                boolean isRiver = false;
                if (riverArray[x + nextX + this.maxSmoothRadius + (z + nextZ + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)] == 1) {
                    this.riverFound = true;
                    isRiver = true;
                }
                float nextRiverHeight = isRiver ? nextBiomeConfig.riverHeight : nextBiomeHeight;
                float riverWeight = this.nearBiomeWeightArray[nextX + this.maxSmoothRadius + (nextZ + this.maxSmoothRadius) * this.maxSmoothDiameter] / (nextRiverHeight + 2.0f);
                riverWeight = Math.abs(riverWeight);
                if (nextRiverHeight > riverCenterHeight) {
                    nextRiverHeight = riverCenterHeight;
                }
                riverVolatilitySum += (isRiver ? nextBiomeConfig.riverVolatility : nextBiomeConfig.biomeVolatility) * riverWeight;
                riverHeightSum += nextRiverHeight * riverWeight;
                riverWeightSum += riverWeight;
            }
        }
        volatilitySum /= WeightSum;
        heightSum /= WeightSum;
        riverVolatilitySum /= riverWeightSum;
        riverHeightSum /= riverWeightSum;
        int waterLevelSum = this.riverFound ? biomeConfig.riverWaterLevel : biomeConfig.waterLevelMax;
        this.waterLevelRaw[x * 5 + z] = (byte)waterLevelSum;
        volatilitySum = volatilitySum * 0.9f + 0.1f;
        heightSum = (heightSum * 4.0f - 1.0f) / 8.0f;
        this.volatilityFactor = volatilitySum;
        this.heightFactor = (double)ySections * (2.0 + (double)heightSum + noiseHeight * 0.2) / 4.0;
        riverVolatilitySum = riverVolatilitySum * 0.9f + 0.1f;
        riverHeightSum = (riverHeightSum * 4.0f - 1.0f) / 8.0f;
        this.riverVol = riverVolatilitySum;
        this.riverHeight = (double)ySections * (2.0 + (double)riverHeightSum + noiseHeight * 0.2) / 4.0;
    }

    private void smoothCHC(double[] chcData, double[] riverData, int x, int z, int maxYSections, int[] biomeArray) {
        float weightSum = 0.0f;
        BiomeConfig centerBiomeConfig = this.toBiomeConfig(biomeArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
        int lookRadius = centerBiomeConfig.CHCSmoothRadius;
        for (int nextX = -lookRadius; nextX <= lookRadius; ++nextX) {
            for (int nextZ = -lookRadius; nextZ <= lookRadius; ++nextZ) {
                weightSum += 1.0f;
                for (int y = 0; y < maxYSections; ++y) {
                    BiomeConfig nextBiomeConfig = this.toBiomeConfig(biomeArray[x + nextX + this.maxSmoothRadius + (z + nextZ + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
                    int n = y;
                    riverData[n] = riverData[n] + nextBiomeConfig.riverHeightMatrix[Math.min(nextBiomeConfig.riverHeightMatrix.length - 1, y)];
                    int n2 = y;
                    chcData[n2] = chcData[n2] + nextBiomeConfig.heightMatrix[Math.min(nextBiomeConfig.heightMatrix.length - 1, y)];
                }
            }
        }
        for (int y = 0; y < chcData.length; ++y) {
            chcData[y] = chcData[y] / (double)weightSum;
            riverData[y] = riverData[y] / (double)weightSum;
        }
    }

    private double[] smoothRemainingData(int x, int z, int[] biomeArray) {
        float weightSum = 0.0f;
        double vol1Sum = 0.0;
        double vol2Sum = 0.0;
        double vol1WeightSum = 0.0;
        double vol2WeightSum = 0.0;
        double maxAverageDepthSum = 0.0;
        double maxAverageHeightSum = 0.0;
        BiomeConfig centerBiomeConfig = this.toBiomeConfig(biomeArray[x + this.maxSmoothRadius + (z + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
        int lookRadius = centerBiomeConfig.smoothRadius;
        for (int nextX = -lookRadius; nextX <= lookRadius; ++nextX) {
            for (int nextZ = -lookRadius; nextZ <= lookRadius; ++nextZ) {
                weightSum += 1.0f;
                BiomeConfig nextBiomeConfig = this.toBiomeConfig(biomeArray[x + nextX + this.maxSmoothRadius + (z + nextZ + this.maxSmoothRadius) * (5 + this.maxSmoothDiameter)]);
                vol1Sum += nextBiomeConfig.volatility1;
                vol2Sum += nextBiomeConfig.volatility2;
                vol1WeightSum += nextBiomeConfig.volatilityWeight1;
                vol2WeightSum += nextBiomeConfig.volatilityWeight2;
                maxAverageDepthSum += nextBiomeConfig.maxAverageDepth;
                maxAverageHeightSum += nextBiomeConfig.maxAverageHeight;
            }
        }
        return new double[]{vol1Sum /= (double)weightSum, vol2Sum /= (double)weightSum, vol1WeightSum /= (double)weightSum, vol2WeightSum /= (double)weightSum, maxAverageDepthSum /= (double)weightSum, maxAverageHeightSum /= (double)weightSum};
    }

    private BiomeConfig toBiomeConfig(int id) {
        BiomeConfig biomeConfig = this.biomes[id];
        if (biomeConfig == null) {
            LocalBiome biome = this.configProvider.getBiomeByOTGIdOrNull(id);
            this.biomes[id] = biomeConfig = biome.getBiomeConfig();
        }
        return biomeConfig;
    }

    private static double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }
}

