/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.world;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.biomes.OTGBiomeProvider;
import com.pg85.otg.forge.blocks.portal.PortalColors;
import com.pg85.otg.forge.dimensions.OTGWorldServerMulti;
import com.pg85.otg.forge.generator.ForgeVanillaBiomeGenerator;
import com.pg85.otg.forge.gui.GuiHandler;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.helpers.ReflectionHelper;
import java.io.File;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OTGWorldType
extends WorldType {
    public OTGWorldType() {
        super("OTG");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_151357_h() {
        return true;
    }

    public BiomeProvider getBiomeProvider(World mcWorld) {
        if (mcWorld.field_72995_K) {
            return super.getBiomeProvider(mcWorld);
        }
        if (mcWorld.field_73011_w.getDimension() != 0 && !(mcWorld instanceof OTGWorldServerMulti)) {
            OTG.log(LogMarker.WARN, "Non-OTG dimension detected, using default biome provider.", new Object[0]);
            return super.getBiomeProvider(mcWorld);
        }
        if (mcWorld.field_73011_w.getDimension() == 0) {
            File worldDirectory;
            if (OTG.getDimensionsConfig() == null) {
                DimensionsConfig savedConfig = DimensionsConfig.loadFromFile(mcWorld.func_72860_G().func_75765_b(), OTG.getEngine().getOTGRootFolder());
                if (savedConfig != null) {
                    OTG.setDimensionsConfig(savedConfig);
                } else {
                    DimensionsConfig modPackConfig = OTG.getEngine().getModPackConfigManager().getModPackConfig(mcWorld.func_72860_G().func_75765_b().getName());
                    if (modPackConfig != null) {
                        DimensionsConfig dimsConfig = new DimensionsConfig(mcWorld.func_72860_G().func_75765_b());
                        dimsConfig.ModPackConfigName = modPackConfig.ModPackConfigName;
                        dimsConfig.ModPackConfigVersion = modPackConfig.ModPackConfigVersion;
                        dimsConfig.Overworld = modPackConfig.Overworld.clone();
                        for (DimensionConfig dimConfig : modPackConfig.Dimensions) {
                            DimensionConfig newConfig = dimConfig.clone();
                            PortalColors.correctPortalColor(newConfig, dimsConfig.getAllDimensions());
                            dimsConfig.Dimensions.add(newConfig);
                        }
                        OTG.setDimensionsConfig(dimsConfig);
                        OTG.getDimensionsConfig().save();
                    } else {
                        WorldConfig worldConfig = WorldConfig.fromDisk(new File(OTG.getEngine().getOTGRootFolder(), "worlds" + File.separator + mcWorld.func_72860_G().func_75765_b().getName()));
                        if (worldConfig == null) {
                            ((ForgeEngine)OTG.getEngine()).getWorldLoader().createDefaultOTGWorld(mcWorld.func_72860_G().func_75765_b().getName());
                            GuiHandler.loadGuiPresets();
                            worldConfig = WorldConfig.fromDisk(new File(OTG.getEngine().getOTGRootFolder(), "worlds" + File.separator + mcWorld.func_72860_G().func_75765_b().getName()));
                        }
                        DimensionsConfig dimsConfig = new DimensionsConfig(mcWorld.func_72860_G().func_75765_b());
                        dimsConfig.Overworld = new DimensionConfig(mcWorld.func_72860_G().func_75765_b().getName(), 0, true, worldConfig);
                        for (String dimToAdd : worldConfig.dimensions) {
                            WorldConfig dimWorldConfig = WorldConfig.fromDisk(new File(OTG.getEngine().getOTGRootFolder(), "worlds" + File.separator + dimToAdd));
                            if (dimWorldConfig == null) continue;
                            DimensionConfig dimConfig = new DimensionConfig(dimToAdd, 0, true, dimWorldConfig);
                            PortalColors.correctPortalColor(dimConfig, dimsConfig.getAllDimensions());
                            dimsConfig.Dimensions.add(dimConfig);
                        }
                        OTG.setDimensionsConfig(dimsConfig);
                        OTG.getDimensionsConfig().save();
                    }
                }
            }
            if (!(worldDirectory = new File(OTG.getEngine().getOTGRootFolder(), "worlds" + File.separator + OTG.getDimensionsConfig().Overworld.PresetName)).exists()) {
                System.out.println("OpenTerrainGenerator: settings does not exist, creating defaults");
                if (!worldDirectory.mkdirs()) {
                    System.out.println("OpenTerrainGenerator: cant create folder " + worldDirectory.getAbsolutePath());
                }
            }
            File worldObjectsDir = new File(OTG.getEngine().getOTGRootFolder(), "worlds" + File.separator + OTG.getDimensionsConfig().Overworld.PresetName + File.separator + "WorldObjects");
            worldObjectsDir.mkdirs();
            File worldBiomesDir = new File(OTG.getEngine().getOTGRootFolder(), "worlds" + File.separator + OTG.getDimensionsConfig().Overworld.PresetName + File.separator + "WorldBiomes");
            worldBiomesDir.mkdirs();
            if (!mcWorld.func_73046_m().func_71264_H()) {
                File worldSaveDir = new File(mcWorld.func_72860_G().func_75765_b().getAbsolutePath().replace("\\.", ""));
                boolean bl = OTG.IsNewWorldBeingCreated = !new File(worldSaveDir, File.separator + "region").exists();
            }
        }
        if (!mcWorld.func_73046_m().func_71264_H()) {
            WorldSettings worldSettings = new WorldSettings(mcWorld.func_72912_H().func_76063_b(), mcWorld.func_72912_H().func_76077_q(), mcWorld.func_72912_H().func_76089_r(), mcWorld.func_72912_H().func_76093_s(), (WorldType)OTGPlugin.OtgWorldType);
            worldSettings.func_82750_a("OpenTerrainGenerator");
            mcWorld.func_72912_H().func_176121_c(mcWorld.func_72912_H().func_76086_u());
            mcWorld.func_72912_H().func_176127_a(worldSettings);
        }
        ForgeWorld world = ((ForgeEngine)OTG.getEngine()).getWorldLoader().getOrCreateForgeWorld(mcWorld);
        Class<? extends BiomeGenerator> biomeGenClass = world.getConfigs().getWorldConfig().biomeMode;
        BiomeGenerator biomeGenerator = OTG.getBiomeModeManager().createCached(biomeGenClass, world);
        BiomeProvider biomeProvider = this.createBiomeProvider(world, biomeGenerator);
        world.setBiomeGenerator(biomeGenerator);
        return biomeProvider;
    }

    private BiomeProvider createBiomeProvider(ForgeWorld world, BiomeGenerator biomeGenerator) {
        BiomeProvider biomeProvider;
        World mcWorld = world.getWorld();
        if (biomeGenerator instanceof ForgeVanillaBiomeGenerator) {
            biomeProvider = mcWorld.field_73011_w.func_177499_m();
            ((ForgeVanillaBiomeGenerator)biomeGenerator).setBiomeProvider(biomeProvider);
        } else {
            biomeProvider = new OTGBiomeProvider(world, biomeGenerator);
            ReflectionHelper.setValueInFieldOfType(mcWorld.field_73011_w, BiomeProvider.class, biomeProvider);
        }
        return biomeProvider;
    }

    public IChunkGenerator getChunkGenerator(World mcWorld, String generatorOptions) {
        ForgeWorld world = ((ForgeEngine)OTG.getEngine()).getWorld(mcWorld);
        if (world != null) {
            return world.getChunkGenerator();
        }
        return super.getChunkGenerator(mcWorld, generatorOptions);
    }

    public int getMinimumSpawnHeight(World mcWorld) {
        ForgeWorld world = ((ForgeEngine)OTG.getEngine()).getWorld(mcWorld);
        if (world == null) {
            return 64;
        }
        return world.getConfigs().getWorldConfig().waterLevelMax;
    }
}

