/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network.server.packets;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.network.OTGPacket;
import com.pg85.otg.forge.network.client.AbstractClientMessageHandler;
import com.pg85.otg.forge.pregenerator.Pregenerator;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.forge.world.ForgeWorldSession;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.helpers.StreamHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PregeneratorStatusPacket
extends OTGPacket {
    public PregeneratorStatusPacket() {
    }

    public PregeneratorStatusPacket(ByteBuf nettyBuffer) {
        super(nettyBuffer);
    }

    public static void writeToStream(ByteBufOutputStream stream) throws IOException {
        stream.writeInt(6);
        stream.writeInt(0);
        ArrayList<Pregenerator> pregenerators = new ArrayList<Pregenerator>();
        for (LocalWorld localWorld : ((ForgeEngine)OTG.getEngine()).getAllWorlds()) {
            if (localWorld.getWorldSession() == null || ((ForgeWorldSession)localWorld.getWorldSession()).getPregenerator() == null) continue;
            pregenerators.add(((ForgeWorldSession)localWorld.getWorldSession()).getPregenerator());
        }
        stream.writeInt(pregenerators.size());
        for (Pregenerator pregenerator : pregenerators) {
            StreamHelper.writeStringToStream((DataOutput)stream, pregenerator.pregenerationWorld);
            stream.writeBoolean(pregenerator.isRunning());
            stream.writeInt(pregenerator.progressScreenWorldSizeInBlocks);
            StreamHelper.writeStringToStream((DataOutput)stream, pregenerator.progressScreenCycle);
            StreamHelper.writeStringToStream((DataOutput)stream, pregenerator.progressScreenRadius);
            StreamHelper.writeStringToStream((DataOutput)stream, pregenerator.preGeneratorProgress);
            StreamHelper.writeStringToStream((DataOutput)stream, pregenerator.preGeneratorProgressStatus);
            StreamHelper.writeStringToStream((DataOutput)stream, pregenerator.progressScreenElapsedTime);
            StreamHelper.writeStringToStream((DataOutput)stream, pregenerator.progressScreenEstimatedTime);
            long i = Runtime.getRuntime().maxMemory();
            long j = Runtime.getRuntime().totalMemory();
            long k = Runtime.getRuntime().freeMemory();
            long l = j - k;
            stream.writeLong(Long.valueOf(PregeneratorStatusPacket.bytesToMb(l)).longValue());
            stream.writeLong(Long.valueOf(PregeneratorStatusPacket.bytesToMb(i)).longValue());
        }
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static class Handler
    extends AbstractClientMessageHandler<PregeneratorStatusPacket> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IMessage handleClientMessage(EntityPlayer player, PregeneratorStatusPacket message, MessageContext ctx) {
            block9: {
                if (Minecraft.func_71410_x().func_71356_B()) {
                    return null;
                }
                try {
                    int packetType = message.getStream().readInt();
                    if (packetType == 0) {
                        int listSize = message.getStream().readInt();
                        for (int i = 0; i < listSize; ++i) {
                            String pregenerationWorld = StreamHelper.readStringFromStream(message.getStream());
                            Boolean pregeneratorIsRunning = message.getStream().readBoolean();
                            int progressScreenWorldSizeInBlocks = message.getStream().readInt();
                            String progressScreenCycle = StreamHelper.readStringFromStream(message.getStream());
                            String progressScreenRadius = StreamHelper.readStringFromStream(message.getStream());
                            String preGeneratorProgress = StreamHelper.readStringFromStream(message.getStream());
                            String preGeneratorProgressStatus = StreamHelper.readStringFromStream(message.getStream());
                            String progressScreenElapsedTime = StreamHelper.readStringFromStream(message.getStream());
                            String progressScreenEstimatedTime = StreamHelper.readStringFromStream(message.getStream());
                            long mbUsed = message.getStream().readLong();
                            long mbTotal = message.getStream().readLong();
                            ForgeWorld forgeWorld = (ForgeWorld)OTG.getEngine().getWorld(pregenerationWorld);
                            if (forgeWorld == null) {
                                forgeWorld = (ForgeWorld)OTG.getEngine().getUnloadedWorld(pregenerationWorld);
                            }
                            if (forgeWorld == null || forgeWorld.getWorldSession() == null) continue;
                            Pregenerator pregenerator = ((ForgeWorldSession)forgeWorld.getWorldSession()).getPregenerator();
                            pregenerator.setPregeneratorIsRunning(pregeneratorIsRunning);
                            pregenerator.progressScreenWorldSizeInBlocks = progressScreenWorldSizeInBlocks;
                            pregenerator.progressScreenCycle = progressScreenCycle;
                            pregenerator.progressScreenRadius = progressScreenRadius;
                            pregenerator.preGeneratorProgress = preGeneratorProgress;
                            pregenerator.preGeneratorProgressStatus = preGeneratorProgressStatus;
                            pregenerator.progressScreenElapsedTime = progressScreenElapsedTime;
                            pregenerator.progressScreenEstimatedTime = progressScreenEstimatedTime;
                            pregenerator.progressScreenServerUsedMbs = mbUsed;
                            pregenerator.progressScreenServerTotalMbs = mbTotal;
                        }
                        break block9;
                    }
                    throw new RuntimeException();
                }
                catch (Exception e) {
                    OTG.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
                    OTG.printStackTrace(LogMarker.FATAL, e);
                }
                finally {
                    message.getData().release();
                }
            }
            return null;
        }
    }
}

