/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network.client.packets;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.network.AbstractServerMessageHandler;
import com.pg85.otg.forge.network.OTGPacket;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.helpers.StreamHelper;
import io.netty.buffer.ByteBuf;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UpdateDimensionSettingsPacket
extends OTGPacket {
    public UpdateDimensionSettingsPacket() {
    }

    public UpdateDimensionSettingsPacket(ByteBuf nettyBuffer) {
        super(nettyBuffer);
    }

    public static void writeToStream(DataOutput stream, ArrayList<DimensionConfig> dimConfigs, boolean isOverWorldIncluded) throws IOException {
        stream.writeInt(6);
        stream.writeInt(0);
        stream.writeInt(dimConfigs.size());
        stream.writeBoolean(isOverWorldIncluded);
        for (DimensionConfig dimConfig : dimConfigs) {
            StreamHelper.writeStringToStream(stream, dimConfig.toYamlString());
        }
    }

    public static class Handler
    extends AbstractServerMessageHandler<UpdateDimensionSettingsPacket> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IMessage handleServerMessage(final EntityPlayer player, UpdateDimensionSettingsPacket message, MessageContext ctx) {
            try {
                if (!player.func_70003_b(2, "openterraingenerator.ui.update")) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Could not update settings: Missing permission 'openterraingenerator.ui.update'"));
                    IMessage iMessage = null;
                    return iMessage;
                }
                int packetType = message.getStream().readInt();
                if (packetType == 0) {
                    int listSize = message.getStream().readInt();
                    final boolean isOverWorld = message.getStream().readBoolean();
                    final ArrayList<DimensionConfig> dimConfigs = new ArrayList<DimensionConfig>();
                    for (int i = 0; i < listSize; ++i) {
                        dimConfigs.add(DimensionConfig.fromYamlString(StreamHelper.readStringFromStream(message.getStream())));
                    }
                    WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
                    mainThread.func_152344_a(new Runnable(){

                        @Override
                        public void run() {
                            for (DimensionConfig dimConfig : dimConfigs) {
                                if (isOverWorld) {
                                    ForgeWorld forgeWorld = null;
                                    forgeWorld = ((ForgeEngine)OTG.getEngine()).getOverWorld();
                                    forgeWorld.getWorldSession().setPregenerationRadius(dimConfig.PregeneratorRadiusInChunks);
                                    dimConfig.PregeneratorRadiusInChunks = forgeWorld.getWorldSession().getPregenerationRadius();
                                    OTG.getDimensionsConfig().Overworld = dimConfig;
                                    double d2 = dimConfig.WorldBorderRadiusInChunks == 0 ? 6.0E7 : (dimConfig.WorldBorderRadiusInChunks == 1 ? 16.0 : (double)(((dimConfig.WorldBorderRadiusInChunks - 1) * 2 + 1) * 16));
                                    forgeWorld.getWorld().func_175723_af().func_177739_c((double)forgeWorld.getSpawnPoint().func_177958_n(), (double)forgeWorld.getSpawnPoint().func_177952_p());
                                    forgeWorld.getWorld().func_175723_af().func_177750_a(d2);
                                    OTGDimensionManager.ApplyGameRulesToWorld(forgeWorld.getWorld(), dimConfig);
                                    continue;
                                }
                                DimensionConfig dimConfigToRemove = null;
                                for (DimensionConfig dimConfig2 : OTG.getDimensionsConfig().Dimensions) {
                                    if (!dimConfig.PresetName.equals(dimConfig2.PresetName)) continue;
                                    dimConfigToRemove = dimConfig2;
                                }
                                ForgeWorld forgeWorld = null;
                                forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(dimConfig.PresetName);
                                if (forgeWorld == null) {
                                    forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(dimConfig.PresetName);
                                }
                                if (forgeWorld == null) continue;
                                forgeWorld.getWorldSession().setPregenerationRadius(dimConfig.PregeneratorRadiusInChunks);
                                dimConfig.PregeneratorRadiusInChunks = forgeWorld.getWorldSession().getPregenerationRadius();
                                OTG.getDimensionsConfig().Dimensions.remove(dimConfigToRemove);
                                OTG.getDimensionsConfig().Dimensions.add(dimConfig);
                                double d2 = dimConfig.WorldBorderRadiusInChunks == 0 ? 6.0E7 : (dimConfig.WorldBorderRadiusInChunks == 1 ? 16.0 : (double)(((dimConfig.WorldBorderRadiusInChunks - 1) * 2 + 1) * 16));
                                forgeWorld.getWorld().func_175723_af().func_177739_c((double)forgeWorld.getSpawnPoint().func_177958_n(), (double)forgeWorld.getSpawnPoint().func_177952_p());
                                forgeWorld.getWorld().func_175723_af().func_177750_a(d2);
                                OTGDimensionManager.ApplyGameRulesToWorld(forgeWorld.getWorld(), dimConfig);
                            }
                            ServerPacketManager.sendDimensionSynchPacketToAllPlayers(player.func_184102_h());
                        }
                    });
                    IMessage iMessage = null;
                    return iMessage;
                }
                try {
                    throw new RuntimeException();
                }
                catch (Exception e) {
                    OTG.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
                    OTG.printStackTrace(LogMarker.FATAL, e);
                }
            }
            finally {
                message.getData().release();
            }
            return null;
        }
    }
}

