/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network;

import com.pg85.otg.forge.network.client.packets.CreateDeleteDimensionPacket;
import com.pg85.otg.forge.network.client.packets.TeleportPlayerPacket;
import com.pg85.otg.forge.network.client.packets.UpdateDimensionSettingsPacket;
import com.pg85.otg.forge.network.server.packets.DimensionLoadUnloadPacket;
import com.pg85.otg.forge.network.server.packets.DimensionSyncPacket;
import com.pg85.otg.forge.network.server.packets.ParticlesPacket;
import com.pg85.otg.forge.network.server.packets.PregeneratorStatusPacket;
import java.lang.reflect.Field;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetworkManager;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDispatcher {
    private static byte PacketId = 0;
    private static final SimpleNetworkWrapper Dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("openterraingenerator");

    public static final void registerPackets() {
        PacketDispatcher.registerMessage(DimensionSyncPacket.Handler.class, DimensionSyncPacket.class, Side.CLIENT);
        PacketDispatcher.registerMessage(ParticlesPacket.Handler.class, ParticlesPacket.class, Side.CLIENT);
        PacketDispatcher.registerMessage(DimensionLoadUnloadPacket.Handler.class, DimensionLoadUnloadPacket.class, Side.CLIENT);
        PacketDispatcher.registerMessage(PregeneratorStatusPacket.Handler.class, PregeneratorStatusPacket.class, Side.CLIENT);
        PacketDispatcher.registerMessage(CreateDeleteDimensionPacket.Handler.class, CreateDeleteDimensionPacket.class, Side.SERVER);
        PacketDispatcher.registerMessage(UpdateDimensionSettingsPacket.Handler.class, UpdateDimensionSettingsPacket.class, Side.SERVER);
        PacketDispatcher.registerMessage(TeleportPlayerPacket.Handler.class, TeleportPlayerPacket.class, Side.SERVER);
    }

    private static final void registerMessage(Class handlerClass, Class messageClass, Side side) {
        byte by = PacketId;
        PacketId = (byte)(by + 1);
        Dispatcher.registerMessage(handlerClass, messageClass, (int)by, side);
    }

    public static final void sendTo(IMessage message, NetworkManager manager) {
        EnumMap channels = null;
        try {
            Field[] fields;
            for (Field field : fields = SimpleNetworkWrapper.class.getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(EnumMap.class)) continue;
                field.setAccessible(true);
                channels = (EnumMap)field.get(Dispatcher);
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (channels == null) {
            throw new RuntimeException();
        }
        ((FMLEmbeddedChannel)channels.get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DISPATCHER);
        ((FMLEmbeddedChannel)channels.get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(manager.channel().attr(NetworkDispatcher.FML_DISPATCHER).get());
        ((FMLEmbeddedChannel)channels.get(Side.SERVER)).writeOutbound(new Object[]{message});
    }

    public static final void sendTo(IMessage message, EntityPlayerMP player) {
        Dispatcher.sendTo(message, player);
    }

    private static final void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        Dispatcher.sendToAllAround(message, point);
    }

    private static final void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static final void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.field_70170_p.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static final void sendToDimension(IMessage message, int dimensionId) {
        Dispatcher.sendToDimension(message, dimensionId);
    }

    public static final void sendToServer(IMessage message) {
        Dispatcher.sendToServer(message);
    }
}

