/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.InputStream;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class OTGPacket
implements IMessage {
    private ByteBuf data = Unpooled.buffer();
    private DataInputStream wrappedStream;

    public OTGPacket() {
    }

    public OTGPacket(ByteBuf data) {
        this.data = data;
    }

    public ByteBuf getData() {
        return this.data;
    }

    public DataInputStream getStream() {
        return this.wrappedStream;
    }

    public void fromBytes(ByteBuf data) {
        int clientProtocolVersion;
        int serverProtocolVersion = data.readInt();
        if (serverProtocolVersion != (clientProtocolVersion = 6)) {
            throw new RuntimeException("Client is using a different version of OTG than server!");
        }
        data.retain();
        this.wrappedStream = new DataInputStream((InputStream)new ByteBufInputStream(data));
    }

    public void toBytes(ByteBuf data) {
        data.writeBytes(this.data);
    }
}

