/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.materials;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.forge.blocks.portal.BlockPortalOTG;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

public class ForgeMaterialData
extends LocalMaterialData {
    private IBlockState blockData;
    private boolean metaIdSet = false;
    private byte metaId;
    private boolean materialIdSet = false;
    private int materialId;
    private boolean hasData;

    private ForgeMaterialData(IBlockState blockData, int blockId, int blockMetaData, boolean hasData) {
        this.blockData = blockData;
        this.materialIdSet = true;
        this.materialId = blockId;
        this.metaIdSet = true;
        this.metaId = (byte)blockMetaData;
        this.hasData = hasData;
    }

    private ForgeMaterialData(IBlockState blockData, String raw, boolean hasData) {
        this.blockData = blockData;
        this.rawEntry = raw;
        this.hasData = hasData;
    }

    private ForgeMaterialData(String raw, boolean hasData) {
        this.blockData = null;
        this.rawEntry = raw;
        this.hasData = hasData;
    }

    public static ForgeMaterialData getBlank() {
        ForgeMaterialData material = new ForgeMaterialData(null, null, false);
        material.isBlank = true;
        return material;
    }

    public static ForgeMaterialData ofString(String input) throws InvalidConfigException {
        DefaultMaterial defaultMaterial;
        if (input.toLowerCase().equals("blank")) {
            return ForgeMaterialData.getBlank();
        }
        String newInput = input;
        Block block = Block.func_149684_b((String)newInput);
        if (block != null) {
            if (block == Blocks.field_150427_aO || block == Blocks.field_150367_z || block == Blocks.field_150400_ck || block == Blocks.field_150487_bG || block == Blocks.field_150389_bf || block == Blocks.field_150401_cl || block == Blocks.field_150481_bH || block == Blocks.field_150387_bl || block == Blocks.field_150476_ad || block == Blocks.field_185769_cV || block == Blocks.field_150370_cb || block == Blocks.field_180396_cN || block == Blocks.field_150372_bz || block == Blocks.field_150485_bF || block == Blocks.field_150390_bg || block == Blocks.field_150446_ar) {
                newInput = input + ":0";
            } else {
                return ForgeMaterialData.ofMinecraftBlock(block, input, false);
            }
        }
        String blockName = newInput;
        int blockData = -1;
        int splitIndex = newInput.lastIndexOf(":");
        if (splitIndex == -1) {
            splitIndex = newInput.lastIndexOf(".");
        }
        if (splitIndex != -1) {
            blockName = newInput.substring(0, splitIndex);
            try {
                blockData = Integer.parseInt(newInput.substring(splitIndex + 1));
            }
            catch (NumberFormatException e) {
                blockName = newInput;
            }
        }
        if ((block = Block.func_149684_b((String)blockName)) == null && (defaultMaterial = DefaultMaterial.getMaterial(blockName)) != null) {
            block = Block.func_149729_e((int)defaultMaterial.id);
            if (blockData == -1 && (block == Blocks.field_150427_aO || block == Blocks.field_150367_z || block == Blocks.field_150400_ck || block == Blocks.field_150487_bG || block == Blocks.field_150389_bf || block == Blocks.field_150401_cl || block == Blocks.field_150481_bH || block == Blocks.field_150387_bl || block == Blocks.field_150476_ad || block == Blocks.field_185769_cV || block == Blocks.field_150370_cb || block == Blocks.field_180396_cN || block == Blocks.field_150372_bz || block == Blocks.field_150485_bF || block == Blocks.field_150390_bg || block == Blocks.field_150446_ar)) {
                blockData = 0;
            }
        }
        if (block != null) {
            if (blockData == -1) {
                return ForgeMaterialData.ofMinecraftBlock(block, newInput, false);
            }
            try {
                return ForgeMaterialData.ofMinecraftBlockState(block.func_176203_a(blockData), newInput, true);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new InvalidConfigException("Illegal meta data for the block type, cannot use " + newInput);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigException("Illegal block data for the block type, cannot use " + newInput);
            }
        }
        return new ForgeMaterialData(newInput, false);
    }

    private static ForgeMaterialData ofIds(int id, int data) {
        Block block = Block.func_149729_e((int)id);
        IBlockState blockData = block.func_176203_a(data);
        return new ForgeMaterialData(blockData, id, data, true);
    }

    public static ForgeMaterialData ofDefaultMaterial(DefaultMaterial material, int data) {
        return ForgeMaterialData.ofIds(material.id, data);
    }

    @Override
    protected ForgeMaterialData ofDefaultMaterialPrivate(DefaultMaterial material, int data) {
        return ForgeMaterialData.ofDefaultMaterial(material, data);
    }

    public static ForgeMaterialData ofMinecraftBlock(Block block, String raw, boolean hasData) {
        return ForgeMaterialData.ofMinecraftBlockState(block.func_176223_P(), raw, hasData);
    }

    public static ForgeMaterialData ofMinecraftBlockState(IBlockState blockData) {
        return new ForgeMaterialData(blockData, null, true);
    }

    public static ForgeMaterialData ofMinecraftBlockState(IBlockState blockData, String raw, boolean hasData) {
        return new ForgeMaterialData(blockData, raw, hasData);
    }

    @Override
    public LocalMaterialData withBlockData(int i) {
        if (this.blockData == null) {
            return this;
        }
        if (i == this.getBlockData()) {
            return this;
        }
        Block block = this.blockData.func_177230_c();
        return ForgeMaterialData.ofMinecraftBlockState(block.func_176203_a(i), this.rawEntry, true);
    }

    @Override
    public LocalMaterialData withDefaultBlockData() {
        if (this.blockData == null) {
            return this;
        }
        Block block = this.blockData.func_177230_c();
        return this.withBlockData(block.func_176201_c(block.func_176223_P()));
    }

    @Override
    public byte getBlockData() {
        if (!this.metaIdSet) {
            this.metaIdSet = true;
            this.metaId = this.blockData == null ? (byte)0 : (byte)this.blockData.func_177230_c().func_176201_c(this.blockData);
        }
        return this.metaId;
    }

    @Override
    public int getBlockId() {
        if (!this.materialIdSet) {
            this.materialIdSet = true;
            this.materialId = this.blockData == null ? 0 : Block.func_149682_b((Block)this.blockData.func_177230_c());
        }
        return this.materialId;
    }

    @Override
    public String getName() {
        if (this.isBlank) {
            return "BLANK";
        }
        if (this.blockData == null) {
            if (this.rawEntry != null) {
                return this.rawEntry;
            }
            return "Unknown";
        }
        Block block = this.blockData.func_177230_c();
        byte data = this.getBlockData();
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial == null) {
            boolean nonDefaultData;
            boolean bl = nonDefaultData = !block.func_176223_P().equals(this.blockData);
            if (nonDefaultData) {
                return Block.field_149771_c.func_177774_c((Object)block) + (!this.hasData ? "" : ":" + data);
            }
            return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        }
        return defaultMaterial.name() + (!this.hasData ? "" : ":" + data);
    }

    public IBlockState internalBlock() {
        return this.blockData;
    }

    @Override
    public boolean isMaterial(DefaultMaterial material) {
        return material.id == this.getBlockId();
    }

    @Override
    public boolean isLiquid() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != null) {
            return defaultMaterial.isLiquid();
        }
        return this.blockData == null ? false : this.blockData.func_185904_a().func_76224_d();
    }

    @Override
    public boolean isSolid() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != null) {
            return defaultMaterial.isSolid();
        }
        return this.blockData == null ? false : this.blockData.func_185904_a().func_76220_a();
    }

    @Override
    public boolean isEmptyOrAir() {
        return this.blockData == null ? true : this.blockData.func_177230_c() == Blocks.field_150350_a;
    }

    @Override
    public boolean isAir() {
        return this.blockData != null && this.blockData.func_177230_c() == Blocks.field_150350_a;
    }

    @Override
    public boolean isEmpty() {
        return this.blockData == null;
    }

    @Override
    public boolean canFall() {
        return this.blockData == null ? false : this.blockData.func_177230_c() instanceof BlockFalling;
    }

    @Override
    public boolean canSnowFallOn() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != null) {
            return defaultMaterial.canSnowFallOn();
        }
        return this.blockData == null ? false : this.blockData.func_185904_a().func_76220_a();
    }

    @Override
    public LocalMaterialData parseForWorld(LocalWorld world) {
        if (!this.checkedFallbacks && this.isEmpty() && this.rawEntry != null) {
            this.checkedFallbacks = true;
            ForgeMaterialData newMaterialData = (ForgeMaterialData)world.getConfigs().getWorldConfig().parseFallback(this.rawEntry);
            if (newMaterialData != null && newMaterialData.blockData != null) {
                this.blockData = newMaterialData.blockData;
                this.metaIdSet = newMaterialData.metaIdSet;
                this.materialIdSet = newMaterialData.materialIdSet;
                this.rawEntry = newMaterialData.rawEntry;
                this.defaultMaterial = newMaterialData.defaultMaterial;
            }
        }
        return this;
    }

    @Override
    public DefaultMaterial toDefaultMaterial() {
        if (this.defaultMaterial == null && !this.parsedDefaultMaterial) {
            this.parsedDefaultMaterial = true;
            if (this.blockData != null) {
                this.defaultMaterial = DefaultMaterial.getMaterial(this.getBlockId());
                if (this.defaultMaterial == null && this.blockData.func_177230_c() instanceof BlockPortalOTG) {
                    this.defaultMaterial = DefaultMaterial.PORTAL;
                }
            }
        }
        return this.defaultMaterial;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ForgeMaterialData)) {
            return false;
        }
        ForgeMaterialData other = (ForgeMaterialData)obj;
        if (this.isBlank != other.isBlank) {
            return false;
        }
        if (this.isBlank) {
            return true;
        }
        return this.blockData != null && other.blockData != null && this.blockData.equals(other.blockData) || this.rawEntry != null && other.rawEntry != null && this.rawEntry.equals(other.rawEntry);
    }

    @Override
    public int hashCode() {
        return 65535 + this.getBlockId() * 16 + this.getBlockData();
    }

    @Override
    public boolean hasData() {
        return this.hasData;
    }
}

