/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.mainmenu;

import com.google.common.collect.Lists;
import com.pg85.otg.forge.gui.mainmenu.OTGGuiListWorldSelectionEntry;
import com.pg85.otg.forge.gui.mainmenu.OTGGuiWorldSelection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class OTGGuiListWorldSelection
extends GuiListExtended {
    private static final Logger LOGGER = LogManager.getLogger();
    private final OTGGuiWorldSelection worldSelectionObj;
    private final List<OTGGuiListWorldSelectionEntry> entries = Lists.newArrayList();
    private int selectedIdx = -1;

    OTGGuiListWorldSelection(OTGGuiWorldSelection p_i46590_1_, Minecraft clientIn, int p_i46590_3_, int p_i46590_4_, int p_i46590_5_, int p_i46590_6_, int p_i46590_7_) {
        super(clientIn, p_i46590_3_, p_i46590_4_, p_i46590_5_, p_i46590_6_, p_i46590_7_);
        this.worldSelectionObj = p_i46590_1_;
        this.refreshList();
    }

    void refreshList() {
        List list;
        ISaveFormat isaveformat = this.field_148161_k.func_71359_d();
        try {
            list = isaveformat.func_75799_b();
        }
        catch (AnvilConverterException anvilconverterexception) {
            LOGGER.error("Couldn't load level list", (Throwable)anvilconverterexception);
            this.field_148161_k.func_147108_a((GuiScreen)new GuiErrorScreen("Unable to load worlds", anvilconverterexception.getMessage()));
            return;
        }
        Collections.sort(list);
        for (WorldSummary worldsummary : list) {
            this.entries.add(new OTGGuiListWorldSelectionEntry(this, worldsummary, this.field_148161_k.func_71359_d()));
        }
    }

    public OTGGuiListWorldSelectionEntry getListEntry(int index) {
        return this.entries.get(index);
    }

    protected int func_148127_b() {
        return this.entries.size();
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 20;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 50;
    }

    void selectWorld(int idx) {
        this.selectedIdx = idx;
        this.worldSelectionObj.selectWorld(this.getSelectedWorld());
    }

    protected boolean func_148131_a(int slotIndex) {
        return slotIndex == this.selectedIdx;
    }

    @Nullable
    public OTGGuiListWorldSelectionEntry getSelectedWorld() {
        return this.selectedIdx >= 0 && this.selectedIdx < this.func_148127_b() ? this.getListEntry(this.selectedIdx) : null;
    }

    public OTGGuiWorldSelection getGuiWorldSelection() {
        return this.worldSelectionObj;
    }
}

