/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.dimensions.base;

import com.pg85.otg.forge.gui.dimensions.base.IGuiListEntry;
import com.pg85.otg.forge.gui.dimensions.base.KeyEntry;
import com.pg85.otg.forge.gui.dimensions.base.OTGGuiSlot;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class OTGGuiListExtended
extends OTGGuiSlot {
    protected OTGGuiListExtended(Minecraft mcIn, int left, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
        super(mcIn, left, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
    }

    @Override
    protected void elementClicked(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
    }

    @Override
    protected boolean isSelected(int slotIndex) {
        return false;
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void drawSlot(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        this.getListEntry(slotIndex).drawEntry(slotIndex, xPos, yPos, this.getListWidth(), heightIn, mouseXIn, mouseYIn, this.isMouseYWithinSlotBounds(mouseYIn) && this.getSlotIndexFromScreenCoords(mouseXIn, mouseYIn) == slotIndex, partialTicks);
    }

    @Override
    protected void updateItemPos(int entryID, int insideLeft, int yPos, float partialTicks) {
        this.getListEntry(entryID).updatePosition(entryID, insideLeft, yPos, partialTicks);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseEvent) {
        int i;
        for (IGuiListEntry entry : this.getAllListEntries()) {
            if (!(entry instanceof KeyEntry)) continue;
            ((KeyEntry)entry).keyTyped('\u0000', 28);
        }
        if (this.isMouseYWithinSlotBounds(mouseY) && (i = this.getSlotIndexFromScreenCoords(mouseX, mouseY)) >= 0) {
            int j = this.left + this.width / 2 - this.getListWidth() / 2 + 2;
            int k = this.top + 4 - this.getAmountScrolled() + i * this.slotHeight + this.headerPadding;
            int l = mouseX - j;
            int i1 = mouseY - k;
            if (this.getListEntry(i).mousePressed(i, mouseX, mouseY, mouseEvent, l, i1)) {
                this.setEnabled(false);
                return true;
            }
        }
        return false;
    }

    public void keyTyped(char typedChar, int keyCode) {
        for (IGuiListEntry entry : this.getAllListEntries()) {
            if (!(entry instanceof KeyEntry)) continue;
            ((KeyEntry)entry).keyTyped(typedChar, keyCode);
        }
    }

    public boolean mouseReleased(int x, int y, int mouseEvent) {
        for (int i = 0; i < this.getSize(); ++i) {
            int j = this.left + this.width / 2 - this.getListWidth() / 2 + 2;
            int k = this.top + 4 - this.getAmountScrolled() + i * this.slotHeight + this.headerPadding;
            int l = x - j;
            int i1 = y - k;
            this.getListEntry(i).mouseReleased(i, x, y, mouseEvent, l, i1);
        }
        this.setEnabled(true);
        return false;
    }

    public abstract IGuiListEntry getListEntry(int var1);

    public abstract ArrayList<IGuiListEntry> getAllListEntries();
}

