/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator.structure;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.network.ServerConfigProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.StructureStart;

public class OTGStrongholdGen
extends MapGenStronghold {
    private final List<Biome> allowedBiomes;
    private boolean ranBiomeCheck;
    private ChunkPos[] structureCoords;
    private double distance;
    private int spread;

    public OTGStrongholdGen(ServerConfigProvider configs, WorldServer world) {
        this.field_75039_c = world;
        this.structureCoords = new ChunkPos[128];
        this.allowedBiomes = new ArrayList<Biome>();
        for (LocalBiome biome : configs.getBiomeArrayByOTGId()) {
            if (biome == null || !biome.getBiomeConfig().strongholdsEnabled) continue;
            this.allowedBiomes.add(((ForgeBiome)biome).getHandle());
        }
        this.distance = MathHelper.func_82713_a((String)String.valueOf(configs.getWorldConfig().strongholdDistance), (double)this.distance, (double)1.0);
        this.structureCoords = new ChunkPos[MathHelper.func_82714_a((String)String.valueOf(configs.getWorldConfig().strongholdCount), (int)this.structureCoords.length, (int)1)];
        this.spread = MathHelper.func_82714_a((String)String.valueOf(configs.getWorldConfig().strongholdSpread), (int)this.spread, (int)1);
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        if (!this.ranBiomeCheck) {
            this.generatePositions();
            this.ranBiomeCheck = true;
        }
        BlockPos blockpos = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(0, 0, 0);
        double d0 = Double.MAX_VALUE;
        for (ChunkPos chunkpos : this.structureCoords) {
            blockpos$mutableblockpos.func_181079_c((chunkpos.field_77276_a << 4) + 8, 32, (chunkpos.field_77275_b << 4) + 8);
            double d1 = blockpos$mutableblockpos.func_177951_i((Vec3i)pos);
            if (blockpos == null) {
                blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
                d0 = d1;
                continue;
            }
            if (!(d1 < d0)) continue;
            blockpos = new BlockPos((Vec3i)blockpos$mutableblockpos);
            d0 = d1;
        }
        return blockpos;
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        if (!this.ranBiomeCheck) {
            this.generatePositions();
            this.ranBiomeCheck = true;
        }
        for (ChunkPos chunkpos : this.structureCoords) {
            if (chunkX != chunkpos.field_77276_a || chunkZ != chunkpos.field_77275_b) continue;
            return true;
        }
        return false;
    }

    private void generatePositions() {
        this.func_143027_a(this.field_75039_c);
        int i = 0;
        for (StructureStart structurestart : this.field_75053_d.values()) {
            if (i >= this.structureCoords.length) continue;
            this.structureCoords[i++] = new ChunkPos(structurestart.func_143019_e(), structurestart.func_143018_f());
        }
        Random random = new Random();
        random.setSeed(this.field_75039_c.func_72905_C());
        double d1 = random.nextDouble() * Math.PI * 2.0;
        int j = 0;
        int k = 0;
        int l = this.field_75053_d.size();
        if (l < this.structureCoords.length) {
            for (int i1 = 0; i1 < this.structureCoords.length; ++i1) {
                double d0 = 4.0 * this.distance + this.distance * (double)j * 6.0 + (random.nextDouble() - 0.5) * this.distance * 2.5;
                int j1 = (int)Math.round(Math.cos(d1) * d0);
                int k1 = (int)Math.round(Math.sin(d1) * d0);
                BlockPos blockpos = this.field_75039_c.func_72959_q().func_180630_a((j1 << 4) + 8, (k1 << 4) + 8, 112, this.allowedBiomes, random);
                if (blockpos != null) {
                    j1 = blockpos.func_177958_n() >> 4;
                    k1 = blockpos.func_177952_p() >> 4;
                }
                if (i1 >= l) {
                    this.structureCoords[i1] = new ChunkPos(j1, k1);
                }
                d1 += Math.PI * 2 / (double)this.spread;
                if (++k != this.spread) continue;
                k = 0;
                this.spread += 2 * this.spread / (++j + 1);
                this.spread = Math.min(this.spread, this.structureCoords.length - i1);
                d1 += random.nextDouble() * Math.PI * 2.0;
            }
        }
    }
}

