/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator.structure;

import com.google.common.base.Preconditions;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.SpawnableObject;
import com.pg85.otg.forge.world.ForgeWorld;
import com.pg85.otg.util.bo3.Rotation;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public final class MojangStructurePart
implements SpawnableObject {
    private final Template spawnObject;
    private final String name;

    public MojangStructurePart(String name, Template spawnObject) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)spawnObject, (Object)"spawnObject");
        this.name = name;
        this.spawnObject = spawnObject;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        World worldMc = ((ForgeWorld)world).getWorld();
        BlockPos blockPos = new BlockPos(x, y, z);
        net.minecraft.util.Rotation rotationMc = this.toMinecraftRotation(rotation);
        PlacementSettings spawnSettings = new PlacementSettings().func_186220_a(rotationMc).func_186218_a(new ChunkPos(blockPos));
        this.spawnObject.func_186253_b(worldMc, blockPos, spawnSettings);
        return true;
    }

    private net.minecraft.util.Rotation toMinecraftRotation(Rotation rotation) {
        switch (rotation) {
            case EAST: {
                return net.minecraft.util.Rotation.CLOCKWISE_90;
            }
            case NORTH: {
                return net.minecraft.util.Rotation.NONE;
            }
            case SOUTH: {
                return net.minecraft.util.Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return net.minecraft.util.Rotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("Unknown rotation: " + (Object)((Object)rotation));
    }

    @Override
    public String getName() {
        return this.name;
    }
}

