/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.dimensions.OTGWorldProvider;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.forge.world.ForgeWorld;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShulkerBox;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class PlayerTracker {
    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (!event.getManager().func_150731_c()) {
            OTG.setDimensionsConfig(null);
            ((ForgeEngine)OTG.getEngine()).getWorldLoader().unloadAndUnregisterAllWorlds();
        }
    }

    @SubscribeEvent
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!event.getManager().func_150731_c()) {
            OTG.setDimensionsConfig(null);
            ((ForgeEngine)OTG.getEngine()).getWorldLoader().unloadAndUnregisterAllWorlds();
        }
    }

    @SubscribeEvent
    public void onConnectionCreated(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        ServerPacketManager.sendPacketsOnConnect(event);
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            DimensionConfig dimConfig;
            if (((OTGWorldProvider)event.player.field_70170_p.field_73011_w).getWelcomeMessage() != null && ((OTGWorldProvider)event.player.field_70170_p.field_73011_w).getWelcomeMessage().trim().length() > 0) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(((OTGWorldProvider)event.player.field_70170_p.field_73011_w).getWelcomeMessage()));
            }
            String itemsToRemoveString = (dimConfig = ((OTGWorldProvider)event.player.field_70170_p.field_73011_w).getDimensionConfig()) != null ? dimConfig.Settings.ItemsToRemoveOnJoinDimension : WorldStandardValues.ITEMS_TO_REMOVE_ON_JOIN_DIMENSION.getDefaultValue();
            boolean itemsRemoved = this.removeItemsFromPlayer(itemsToRemoveString, event.player);
            String itemsToAddString = dimConfig != null ? dimConfig.Settings.ItemsToAddOnJoinDimension : WorldStandardValues.ITEMS_TO_ADD_ON_JOIN_DIMENSION.getDefaultValue();
            boolean itemsAdded = this.giveItemsToPlayer(itemsToAddString, event.player);
            if (itemsRemoved) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been removed from your inventory"));
            }
            if (itemsAdded) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been added to your inventory"));
            }
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.field_70170_p.field_73011_w instanceof OTGWorldProvider) {
            DimensionConfig dimConfig;
            if (((OTGWorldProvider)event.player.field_70170_p.field_73011_w).getDepartMessage() != null && ((OTGWorldProvider)event.player.field_70170_p.field_73011_w).getDepartMessage().trim().length() > 0) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(((OTGWorldProvider)event.player.field_70170_p.field_73011_w).getDepartMessage()));
            }
            String itemsToRemoveString = (dimConfig = ((OTGWorldProvider)event.player.field_70170_p.field_73011_w).getDimensionConfig()) != null ? dimConfig.Settings.ItemsToRemoveOnLeaveDimension : WorldStandardValues.ITEMS_TO_REMOVE_ON_LEAVE_DIMENSION.getDefaultValue();
            boolean itemsRemoved = this.removeItemsFromPlayer(itemsToRemoveString, event.player);
            String itemsToAddString = dimConfig != null ? dimConfig.Settings.ItemsToAddOnLeaveDimension : WorldStandardValues.ITEMS_TO_ADD_ON_LEAVE_DIMENSION.getDefaultValue();
            boolean itemsAdded = this.giveItemsToPlayer(itemsToAddString, event.player);
            if (itemsRemoved) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been removed from your inventory"));
            }
            if (itemsAdded) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been added to your inventory"));
            }
        }
    }

    @SubscribeEvent
    public void playerRespawned(PlayerEvent.PlayerRespawnEvent event) {
        DimensionConfig dimConfig;
        String itemsToAddString;
        boolean itemsAdded;
        if (event.player.field_70170_p.field_73011_w instanceof OTGWorldProvider && (itemsAdded = this.giveItemsToPlayer(itemsToAddString = (dimConfig = ((OTGWorldProvider)event.player.field_70170_p.field_73011_w).getDimensionConfig()) != null ? dimConfig.Settings.ItemsToAddOnRespawn : WorldStandardValues.ITEMS_TO_ADD_ON_RESPAWN.getDefaultValue(), event.player))) {
            event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been added to your inventory"));
        }
    }

    @SubscribeEvent
    public void playerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        WorldServer fromWorld = DimensionManager.getWorld((int)event.fromDim);
        if (fromWorld != null && fromWorld.field_73011_w instanceof OTGWorldProvider) {
            DimensionConfig dimConfig;
            if (((OTGWorldProvider)fromWorld.field_73011_w).getDepartMessage() != null && ((OTGWorldProvider)fromWorld.field_73011_w).getDepartMessage().trim().length() > 0) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(((OTGWorldProvider)fromWorld.field_73011_w).getDepartMessage()));
            }
            String itemsToRemoveString = (dimConfig = ((OTGWorldProvider)fromWorld.field_73011_w).getDimensionConfig()) != null ? dimConfig.Settings.ItemsToRemoveOnLeaveDimension : WorldStandardValues.ITEMS_TO_REMOVE_ON_LEAVE_DIMENSION.getDefaultValue();
            boolean itemsRemoved = this.removeItemsFromPlayer(itemsToRemoveString, event.player);
            String itemsToAddString = dimConfig != null ? dimConfig.Settings.ItemsToAddOnLeaveDimension : WorldStandardValues.ITEMS_TO_ADD_ON_LEAVE_DIMENSION.getDefaultValue();
            boolean itemsAdded = this.giveItemsToPlayer(itemsToAddString, event.player);
            if (itemsRemoved) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been removed from your inventory"));
            }
            if (itemsAdded) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been added to your inventory"));
            }
        }
        WorldServer toWorld = DimensionManager.getWorld((int)event.toDim);
        if (toWorld.field_73011_w instanceof OTGWorldProvider) {
            DimensionConfig dimConfig;
            if (((OTGWorldProvider)toWorld.field_73011_w).getWelcomeMessage() != null && ((OTGWorldProvider)toWorld.field_73011_w).getWelcomeMessage().trim().length() > 0) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(((OTGWorldProvider)toWorld.field_73011_w).getWelcomeMessage()));
            }
            String itemsToRemoveString = (dimConfig = ((OTGWorldProvider)toWorld.field_73011_w).getDimensionConfig()) != null ? dimConfig.Settings.ItemsToRemoveOnJoinDimension : WorldStandardValues.ITEMS_TO_REMOVE_ON_JOIN_DIMENSION.getDefaultValue();
            boolean itemsRemoved = this.removeItemsFromPlayer(itemsToRemoveString, event.player);
            String itemsToAddString = dimConfig != null ? dimConfig.Settings.ItemsToAddOnJoinDimension : WorldStandardValues.ITEMS_TO_ADD_ON_JOIN_DIMENSION.getDefaultValue();
            boolean itemsAdded = this.giveItemsToPlayer(itemsToAddString, event.player);
            if (itemsRemoved) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been removed from your inventory"));
            }
            if (itemsAdded) {
                event.player.func_145747_a((ITextComponent)new TextComponentString("Items have been added to your inventory"));
            }
        }
    }

    private boolean giveItemsToPlayer(String itemsToAddString, EntityPlayer player) {
        boolean itemsAdded = false;
        if (itemsToAddString != null && (itemsToAddString = itemsToAddString.trim()).length() > 0) {
            int i;
            if (itemsToAddString.charAt(0) == '[' && itemsToAddString.charAt(itemsToAddString.length() - 1) == ']') {
                itemsToAddString = itemsToAddString.substring(1, itemsToAddString.length() - 1);
            }
            ArrayList<String> params = new ArrayList<String>();
            int paramStartIndex = 0;
            boolean foundParam = false;
            for (i = 0; i < itemsToAddString.length(); ++i) {
                if (itemsToAddString.charAt(i) != '\"') continue;
                if (!foundParam) {
                    paramStartIndex = i;
                    foundParam = true;
                    continue;
                }
                params.add(itemsToAddString.substring(paramStartIndex + 1, i));
                foundParam = false;
            }
            for (i = 0; i < params.size(); i += 4) {
                this.giveItemToPlayer(player, params.size() <= i + 0 ? null : (String)params.get(i + 0), params.size() <= i + 1 ? null : (String)params.get(i + 1), params.size() <= i + 2 ? null : (String)params.get(i + 2), params.size() <= i + 3 ? null : (String)params.get(i + 3));
                itemsAdded = true;
            }
        }
        return itemsAdded;
    }

    private void giveItemToPlayer(EntityPlayer entityplayer, String itemName, String amountString, String metaDataString, String nbtDataString) {
        boolean flag;
        int amount;
        Item item;
        try {
            item = CommandBase.func_147179_f(null, (String)itemName);
        }
        catch (NumberInvalidException e1) {
            e1.printStackTrace();
            return;
        }
        try {
            amount = CommandBase.func_175764_a((String)amountString, (int)1, (int)item.func_77639_j());
        }
        catch (NumberInvalidException e1) {
            e1.printStackTrace();
            return;
        }
        int meta = 0;
        if (metaDataString != null && metaDataString.length() > 0) {
            try {
                meta = CommandBase.func_175755_a((String)metaDataString);
            }
            catch (NumberInvalidException e1) {
                e1.printStackTrace();
                return;
            }
        }
        ItemStack itemstack = new ItemStack(item, amount, meta);
        if (nbtDataString != null && nbtDataString.length() > 0) {
            try {
                itemstack.func_77982_d(JsonToNBT.func_180713_a((String)nbtDataString));
            }
            catch (NBTException nbtexception) {
                try {
                    throw new CommandException("commands.give.tagError", new Object[]{nbtexception.getMessage()});
                }
                catch (CommandException e) {
                    e.printStackTrace();
                }
            }
        }
        if (flag = entityplayer.field_71071_by.func_70441_a(itemstack)) {
            entityplayer.field_70170_p.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((entityplayer.func_70681_au().nextFloat() - entityplayer.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.field_71069_bz.func_75142_b();
        }
        if (flag && itemstack.func_190926_b()) {
            itemstack.func_190920_e(1);
            EntityItem entityitem1 = entityplayer.func_71019_a(itemstack, false);
            if (entityitem1 != null) {
                entityitem1.func_174870_v();
            }
        } else {
            EntityItem entityitem = entityplayer.func_71019_a(itemstack, false);
            if (entityitem != null) {
                entityitem.func_174868_q();
                entityitem.func_145797_a(entityplayer.func_70005_c_());
            }
        }
    }

    private boolean removeItemsFromPlayer(String itemsToRemoveString, EntityPlayer player) {
        boolean itemsRemoved = false;
        if (itemsToRemoveString != null && (itemsToRemoveString = itemsToRemoveString.trim()).length() > 0) {
            int i;
            if (itemsToRemoveString.charAt(0) == '[' && itemsToRemoveString.charAt(itemsToRemoveString.length() - 1) == ']') {
                itemsToRemoveString = itemsToRemoveString.substring(1, itemsToRemoveString.length() - 1);
            }
            ArrayList<String> params = new ArrayList<String>();
            int paramStartIndex = 0;
            boolean foundParam = false;
            for (i = 0; i < itemsToRemoveString.length(); ++i) {
                if (itemsToRemoveString.charAt(i) != '\"') continue;
                if (!foundParam) {
                    paramStartIndex = i;
                    foundParam = true;
                    continue;
                }
                params.add(itemsToRemoveString.substring(paramStartIndex + 1, i));
                foundParam = false;
            }
            for (i = 0; i < params.size(); i += 4) {
                this.removeItemFromPlayer(player, params.size() <= i + 0 ? null : (String)params.get(i + 0), params.size() <= i + 1 ? null : (String)params.get(i + 1), params.size() <= i + 2 ? null : (String)params.get(i + 2), params.size() <= i + 3 ? null : (String)params.get(i + 3));
                itemsRemoved = true;
            }
        }
        return itemsRemoved;
    }

    private void removeItemFromPlayer(EntityPlayer entityplayer, String itemName, String amountString, String metaDataString, String nbtDataString) {
        int amount;
        Item item;
        try {
            item = CommandBase.func_147179_f(null, (String)itemName);
        }
        catch (NumberInvalidException e1) {
            e1.printStackTrace();
            return;
        }
        try {
            amount = CommandBase.func_175764_a((String)amountString, (int)-1, (int)item.func_77639_j());
        }
        catch (NumberInvalidException e1) {
            e1.printStackTrace();
            return;
        }
        int meta = 0;
        if (metaDataString != null && metaDataString.length() > 0) {
            try {
                meta = CommandBase.func_175755_a((String)metaDataString);
            }
            catch (NumberInvalidException e1) {
                e1.printStackTrace();
                return;
            }
        }
        NBTTagCompound nbtTagCompound = null;
        if (nbtDataString != null && nbtDataString.length() > 0) {
            try {
                nbtTagCompound = JsonToNBT.func_180713_a((String)nbtDataString);
            }
            catch (NBTException nbtexception) {
                try {
                    throw new CommandException("commands.give.tagError", new Object[]{nbtexception.getMessage()});
                }
                catch (CommandException e) {
                    e.printStackTrace();
                }
            }
        }
        int amountRemoved = this.clearMatchingItems(entityplayer.field_71071_by, item, meta, amount, nbtTagCompound);
        if (amount == -1 || amountRemoved < amount) {
            amountRemoved += this.clearMatchingItemsEnderChest(entityplayer.func_71005_bN(), item, meta, amount, nbtTagCompound);
        }
    }

    private int clearMatchingItems(InventoryPlayer _this, @Nullable Item itemIn, int metadataIn, int removeCount, @Nullable NBTTagCompound itemNBT) {
        int i = 0;
        for (int j = 0; j < _this.func_70302_i_(); ++j) {
            NBTTagCompound BlockEntityTag;
            NBTTagList itemsTag;
            ItemStack itemstack = _this.func_70301_a(j);
            if (itemstack.func_77973_b() instanceof ItemShulkerBox && itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74775_l("BlockEntityTag") != null && (itemsTag = (BlockEntityTag = itemstack.func_77978_p().func_74775_l("BlockEntityTag")).func_150295_c("Items", 10)) != null) {
                for (int l = 0; l < itemsTag.func_74745_c(); ++l) {
                    NBTTagCompound item = itemsTag.func_150305_b(l);
                    String id = item.func_74779_i("id");
                    int count = itemstack.func_190916_E();
                    NBTTagCompound nbtTag = item.func_74775_l("tag");
                    if (!id.equals(itemIn.getRegistryName().toString()) || !nbtTag.equals((Object)itemNBT)) continue;
                    if (count - removeCount <= 0) {
                        itemsTag.func_74744_a(l);
                        i += count;
                        continue;
                    }
                    itemstack.func_190920_e(count - removeCount);
                    return removeCount;
                }
            }
            if (itemstack.func_190926_b() || itemIn != null && itemstack.func_77973_b() != itemIn || metadataIn > -1 && itemstack.func_77960_j() != metadataIn || itemNBT != null && !NBTUtil.func_181123_a((NBTBase)itemNBT, (NBTBase)itemstack.func_77978_p(), (boolean)true)) continue;
            int k = removeCount <= 0 ? itemstack.func_190916_E() : Math.min(removeCount - i, itemstack.func_190916_E());
            i += k;
            if (removeCount == 0) continue;
            itemstack.func_190918_g(k);
            if (itemstack.func_190926_b()) {
                _this.func_70299_a(j, ItemStack.field_190927_a);
            }
            if (removeCount <= 0 || i < removeCount) continue;
            return i;
        }
        if (!_this.func_70445_o().func_190926_b()) {
            if (itemIn != null && _this.func_70445_o().func_77973_b() != itemIn) {
                return i;
            }
            if (metadataIn > -1 && _this.func_70445_o().func_77960_j() != metadataIn) {
                return i;
            }
            if (itemNBT != null && !NBTUtil.func_181123_a((NBTBase)itemNBT, (NBTBase)_this.func_70445_o().func_77978_p(), (boolean)true)) {
                return i;
            }
            int l = removeCount <= 0 ? _this.func_70445_o().func_190916_E() : Math.min(removeCount - i, _this.func_70445_o().func_190916_E());
            i += l;
            if (removeCount != 0) {
                _this.func_70445_o().func_190918_g(l);
                if (_this.func_70445_o().func_190926_b()) {
                    _this.func_70437_b(ItemStack.field_190927_a);
                }
                if (removeCount > 0 && i >= removeCount) {
                    return i;
                }
            }
        }
        return i;
    }

    private int clearMatchingItemsEnderChest(InventoryEnderChest inventory, @Nullable Item itemIn, int metadataIn, int removeCount, @Nullable NBTTagCompound itemNBT) {
        int i = 0;
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            NBTTagCompound BlockEntityTag;
            NBTTagList itemsTag;
            ItemStack itemstack = inventory.func_70301_a(j);
            if (itemstack.func_77973_b() instanceof ItemShulkerBox && itemstack.func_77978_p() != null && itemstack.func_77978_p().func_74775_l("BlockEntityTag") != null && (itemsTag = (BlockEntityTag = itemstack.func_77978_p().func_74775_l("BlockEntityTag")).func_150295_c("Items", 10)) != null) {
                for (int l = 0; l < itemsTag.func_74745_c(); ++l) {
                    NBTTagCompound item = itemsTag.func_150305_b(l);
                    String id = item.func_74779_i("id");
                    int count = itemstack.func_190916_E();
                    NBTTagCompound nbtTag = item.func_74775_l("tag");
                    if (!id.equals(itemIn.getRegistryName().toString()) || !nbtTag.equals((Object)itemNBT)) continue;
                    if (count - removeCount <= 0) {
                        itemsTag.func_74744_a(l);
                        i += count;
                        continue;
                    }
                    itemstack.func_190920_e(count - removeCount);
                    return removeCount;
                }
            }
            if (itemstack.func_190926_b() || itemIn != null && itemstack.func_77973_b() != itemIn || metadataIn > -1 && itemstack.func_77960_j() != metadataIn || itemNBT != null && !NBTUtil.func_181123_a((NBTBase)itemNBT, (NBTBase)itemstack.func_77978_p(), (boolean)true)) continue;
            int k = removeCount <= 0 ? itemstack.func_190916_E() : Math.min(removeCount - i, itemstack.func_190916_E());
            i += k;
            if (removeCount == 0) continue;
            itemstack.func_190918_g(k);
            if (itemstack.func_190926_b()) {
                inventory.func_70299_a(j, ItemStack.field_190927_a);
            }
            if (removeCount <= 0 || i < removeCount) continue;
            return i;
        }
        return i;
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (event.getEntity().func_130014_f_() != null) {
            if (OTG.getDimensionsConfig() == null) {
                return;
            }
            ForgeWorld forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorld(event.getEntity().func_130014_f_());
            if (forgeWorld != null) {
                DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(forgeWorld.getName());
                double baseGravity = 0.08;
                double gravityFactor = 1.0 / (baseGravity / dimConfig.Settings.GravityFactor);
                double baseThreshHold = 3.0;
                double newThreshold = baseThreshHold * (1.0 / gravityFactor);
                double newDistance = (double)(event.getDistance() + 3.0f) * gravityFactor - newThreshold;
                event.setDamageMultiplier((float)gravityFactor);
                event.setDistance((float)newDistance);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }
}

