/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.commands.runnables;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.forge.biomes.OTGBiome;
import com.pg85.otg.forge.commands.BaseCommand;
import com.pg85.otg.forge.world.WorldHelper;
import com.pg85.otg.logging.LogMarker;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class MapWriter
implements Runnable {
    public static final int[] defaultColors = new int[]{0x3333FF, 0x999900, 0xFFCC33, 0x333300, 65280, 30464, 0x99CC66, 52428, 0, 0, 0xFFFFFF, 0x66FFFF, 0xCCCCCC, 0xCC9966, 0xFF33CC, 0xFF9999, 0xFFFF00, 0x996600, 39168, 13056, 0x666600};
    public static boolean isWorking = false;
    private World world;
    private int size;
    private ICommandSender sender;
    private Angle angle;
    private int offsetX;
    private int offsetZ;
    private String label;

    public MapWriter(World mcWorld, int _size, Angle _angle, ICommandSender _sender, int _offsetX, int _offsetZ, String _label) {
        this.world = mcWorld;
        this.size = _size;
        this.sender = _sender;
        this.angle = _angle;
        this.offsetX = _offsetX;
        this.offsetZ = _offsetZ;
        this.label = _label;
    }

    private int[] getColors(World world2) {
        LocalWorld forgeWorld = OTG.getWorld(WorldHelper.getName(world2));
        if (forgeWorld == null) {
            return defaultColors;
        }
        LocalBiome[] biomes = forgeWorld.getConfigs().getBiomeArrayByOTGId();
        int[] colors = new int[biomes.length];
        OTG.log(LogMarker.DEBUG, "ForgeWorld settings biomes.length::{}", biomes.length);
        for (LocalBiome biome : biomes) {
            int color;
            if (biome == null) continue;
            BiomeConfig biomeConfig = biome.getBiomeConfig();
            colors[biome.getIds().getOTGBiomeId()] = color = biomeConfig.biomeColor;
        }
        return colors;
    }

    @Override
    public void run() {
        if (isWorking) {
            this.sender.func_145747_a((ITextComponent)new TextComponentString(BaseCommand.ERROR_COLOR + "Another instance of map writer is running"));
            return;
        }
        isWorking = true;
        int height = this.size;
        int width = this.size;
        LocalWorld localWorld = OTG.getWorld(WorldHelper.getName(this.world));
        int[] colors = this.getColors(this.world);
        this.sender.func_145747_a((ITextComponent)new TextComponentString(BaseCommand.MESSAGE_COLOR + "Generating map..."));
        this.sender.func_145747_a((ITextComponent)new TextComponentString(BaseCommand.MESSAGE_COLOR + "You may notice a short performance impact during this process."));
        Biome[] biomeBuffer = new Biome[256];
        BufferedImage biomeImage = new BufferedImage(height * 16, width * 16, 1);
        BufferedImage temperatureImage = new BufferedImage(height * 16, width * 16, 1);
        int imageX = 0;
        int imageY = 0;
        for (int x = -height / 2; x < height / 2; ++x) {
            for (int z = -width / 2; z < width / 2; ++z) {
                biomeBuffer = this.world.func_72959_q().func_76937_a(biomeBuffer, this.offsetX + x * 16, this.offsetZ + z * 16, 16, 16);
                for (int x1 = 0; x1 < 16; ++x1) {
                    for (int z1 = 0; z1 < 16; ++z1) {
                        switch (this.angle) {
                            case d0: {
                                imageX = (x + height / 2) * 16 + x1;
                                imageY = (z + width / 2) * 16 + z1;
                                break;
                            }
                            case d90: {
                                imageX = width * 16 - ((z + width / 2) * 16 + z1 + 1);
                                imageY = (x + height / 2) * 16 + x1;
                                break;
                            }
                            case d180: {
                                imageX = height * 16 - ((x + height / 2) * 16 + x1 + 1);
                                imageY = width * 16 - ((z + width / 2) * 16 + z1 + 1);
                                break;
                            }
                            case d270: {
                                imageX = (z + width / 2) * 16 + z1;
                                imageY = height * 16 - ((x + height / 2) * 16 + x1 + 1);
                            }
                        }
                        int arrayPosition = x1 + 16 * z1;
                        int biomeId = this.getOTGBiomeId(localWorld, biomeBuffer[arrayPosition]);
                        try {
                            biomeImage.setRGB(imageX, imageY, colors[biomeId]);
                            Color temperatureColor = this.getBiomeTemperatureColor(biomeBuffer[arrayPosition], localWorld);
                            temperatureImage.setRGB(imageX, imageY, temperatureColor.getRGB());
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            OTG.log(LogMarker.DEBUG, "BiomeBuff Idx::{}<{}x/{}z>, Len::{}, ID::{} | Colors Len::{}", arrayPosition, x1, z1, biomeBuffer.length, OTGBiome.func_185362_a((Biome)biomeBuffer[arrayPosition]), colors.length);
                        }
                    }
                }
            }
        }
        this.sender.func_145747_a((ITextComponent)new TextComponentString(BaseCommand.MESSAGE_COLOR + "Writing images..."));
        try {
            ImageIO.write((RenderedImage)biomeImage, "png", new File(this.label + this.world.func_72912_H().func_76065_j() + "_biome.png"));
            ImageIO.write((RenderedImage)temperatureImage, "png", new File(this.label + this.world.func_72912_H().func_76065_j() + "_temperature.png"));
            this.sender.func_145747_a((ITextComponent)new TextComponentString(BaseCommand.MESSAGE_COLOR + "Done"));
        }
        catch (IOException e) {
            this.sender.func_145747_a((ITextComponent)new TextComponentString(BaseCommand.ERROR_COLOR + "Exception while writing images: " + e.getLocalizedMessage()));
            OTG.log(LogMarker.ERROR, "Failed to write image.", new Object[0]);
            OTG.printStackTrace(LogMarker.ERROR, e);
        }
        isWorking = false;
    }

    private Color getBiomeTemperatureColor(Biome biome, LocalWorld world) {
        float temperature = world != null ? world.getBiomeByOTGIdOrNull((int)this.getOTGBiomeId((LocalWorld)world, (Biome)biome)).getBiomeConfig().biomeTemperature : biome.func_185353_n();
        float cappedTemperature = Math.min(1.0f, temperature);
        return Color.getHSBColor(0.7f - cappedTemperature * 0.7f, 0.9f, temperature * 0.7f + 0.3f);
    }

    private int getOTGBiomeId(LocalWorld world, Biome biome) {
        if (biome instanceof OTGBiome) {
            return world.getBiomeByNameOrNull(biome.func_185359_l()).getIds().getOTGBiomeId();
        }
        return Biome.func_185362_a((Biome)biome);
    }

    public static enum Angle {
        d0,
        d90,
        d180,
        d270;

    }
}

